﻿Module modCálculos
    ''' <summary>
    ''' Cálculo do custo de uma hora normal, de acordo com a lei.
    ''' </summary>
    ''' <param name="VencimentoBase">Valor do vencimento base</param>
    ''' <param name="HorasSemanais">Número de horas normais semanais</param>
    ''' <returns>Custo de uma hora normal</returns>
    ''' <remarks></remarks>
    Public Function funVencimentoHora(ByVal VencimentoBase As Single, ByVal HorasSemanais As Integer) As Single
        Try
            funVencimentoHora = (VencimentoBase * 12) / (HorasSemanais * 52)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Function
    ''' <summary>
    ''' Cálculo do custo de um dia de trabalho, de acordo com a lei.
    ''' </summary>
    ''' <param name="VencimentoBase">Valor do vencimento base</param>
    ''' <returns>Custo de um dia de trabalho</returns>
    ''' <remarks></remarks>
    Public Function funVencimentoDiário(ByVal VencimentoBase As Single) As Single
        Try
            funVencimentoDiário = VencimentoBase / 30
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Function
    ''' <summary>
    ''' Função para validar o Número de Contribuinte Fiscal
    ''' </summary>
    ''' <param name="contrib">Número de Contribuinte a testar</param>
    ''' <returns>Retorna True se o Número de Contibuinte for válido</returns>
    ''' <remarks></remarks>
    Public Function funValidarNIF(ByVal contrib As String) As Boolean
        Try
            Dim s As String = contrib
            Dim c As Char
            Dim i, checkDigit As Integer

            If (s.Length = 9) Then
                c = s.Chars(0)
                If (c.Equals("1"c) Or c.Equals("2"c) Or c.Equals("5"c) Or c.Equals("6"c) Or c.Equals("8"c) Or c.Equals("9"c)) Then
                    checkDigit = Val(c) * 9
                    For i = 2 To 8
                        checkDigit += Val(s.Chars(i - 1)) * (10 - i)
                    Next
                    checkDigit = 11 - (checkDigit Mod 11)
                    If (checkDigit >= 10) Then checkDigit = 0
                    If (checkDigit = Val(s.Chars(8))) Then Return True
                End If
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
        Return False
    End Function
    ''' <summary>
    ''' Função para validar o NIB
    ''' </summary>
    ''' <param name="NIB"></param>
    ''' <returns>Retorna True se o NIB for válido</returns>
    ''' <remarks></remarks>
    Public Function funValidarNIB(ByRef NIB As String) As Boolean
        Try
            Dim s As Long
            Dim i, i2, checkDigit As Integer
            Dim nib_auxiliar As String
            Dim Tabela_pesos(31) As Byte
            Dim Tabela_bancos(40) As Integer

            Tabela_pesos(1) = 85
            Tabela_pesos(2) = 57
            Tabela_pesos(3) = 93
            Tabela_pesos(4) = 19
            Tabela_pesos(5) = 31
            Tabela_pesos(6) = 71
            Tabela_pesos(7) = 75
            Tabela_pesos(8) = 56
            Tabela_pesos(9) = 25
            Tabela_pesos(10) = 51
            Tabela_pesos(11) = 73
            Tabela_pesos(12) = 17
            Tabela_pesos(13) = 89
            Tabela_pesos(14) = 38
            Tabela_pesos(15) = 62
            Tabela_pesos(16) = 45
            Tabela_pesos(17) = 53
            Tabela_pesos(18) = 15
            Tabela_pesos(19) = 50
            Tabela_pesos(20) = 5
            Tabela_pesos(21) = 49
            Tabela_pesos(22) = 34
            Tabela_pesos(23) = 81
            Tabela_pesos(24) = 76
            Tabela_pesos(25) = 27
            Tabela_pesos(26) = 90
            Tabela_pesos(27) = 9
            Tabela_pesos(28) = 30
            Tabela_pesos(29) = 3
            Tabela_pesos(30) = 10
            Tabela_pesos(31) = 1

            Tabela_bancos(1) = 7 ' deve acrescentar os cÃ³digos de banco que conheÃ§a para validar o banco.
            Tabela_bancos(2) = 10
            Tabela_bancos(3) = 12
            Tabela_bancos(4) = 18
            Tabela_bancos(5) = 32
            Tabela_bancos(6) = 33
            Tabela_bancos(7) = 35
            Tabela_bancos(8) = 36
            Tabela_bancos(9) = 43

            nib_auxiliar = 0
            nib_auxiliar = NIB
            i = 1
            checkDigit = 0

            If nib_auxiliar < 1.0E+17 Or nib_auxiliar > 1.0E+21 Then
                ' Comprimento do NIB errado
                Return (False)
            End If

            s = 0

            For i2 = 1 To 9
                If Mid(nib_auxiliar, 1, (4)) = Tabela_bancos(i2) Then
                    s = 1
                End If
            Next

            If s = 0 Then
                ' Código do banco errado
                Return (False)
            End If

            For i = i To 19
                checkDigit = checkDigit + (Mid(nib_auxiliar, i, (1)) * Tabela_pesos(i + 10))
            Next

            Dim dblDivisao As Double = checkDigit / 97
            s = Int(dblDivisao) * 97
            checkDigit = checkDigit - s
            checkDigit = 98 - checkDigit

            If (checkDigit = Mid(nib_auxiliar, 20, (2))) Then
                Return (True)
            Else
                ' NIB Inválido
                Return (False)
            End If
        Catch ex As Exception
            modLog.subErro(ex)
            Return False
        End Try
    End Function
End Module
