﻿Module modFeriados
    'Dias Feriados
    Public Function funDiaFeriado(ByVal Data As Date) As String
        Dim Dia As Integer = Data.Day
        Dim Mes As Integer = Data.Month
        Dim Ano As Integer = Data.Year

        'Festas moveis
        If Data.Date = Carnaval(Ano).Date Then Return "E" '"Entrudo/Carnaval"
        If Data.Date = SextaFeiraSanta(Ano).Date Then Return "S" '"Sexta-Feira Santa"
        If Data.Date = Pascoa(Ano).Date Then Return "P" '"Páscoa"
        If Data.Date = CorpoDeDeus(Ano).Date Then Return "S" '"Corpo de Deus"

        'Feriados e dias Santos Fixos
        If Dia = 1 And Mes = 1 Then Return "S" '"Ano Novo"
        If Dia = 25 And Mes = 4 Then Return "F" '"Dia da Liberdade"
        If Dia = 1 And Mes = 5 Then Return "F" '"Dia do Trabalhador"
        If Dia = 10 And Mes = 6 Then Return "F" '"Dia de Portugal"
        If Dia = 15 And Mes = 8 Then Return "S" '"Assunção de Maria"
        If Dia = 5 And Mes = 10 Then Return "F" '"Implantação da República"
        If Dia = 1 And Mes = 11 Then Return "S" '"Todos os Santos"
        If Dia = 1 And Mes = 12 Then Return "F" '"Restauração da Independência"
        If Dia = 8 And Mes = 12 Then Return "S" '"Imaculada Conceição"
        If Dia = 25 And Mes = 12 Then Return "N" '"Natal"

        'Feriados Locais
        If Dia = 24 And Mes = 6 Then Return "R" '"Feriado Regional(Sº João - Porto)"

        Return "" 'Dia Util"
    End Function

    'Festas Moveis
    Public Function Carnaval(ByVal Ano As Integer) As Date
        Dim D As Date = Pascoa(Ano)
        Return DateSerial(Ano, D.Month, D.Day - 47)
    End Function

    Public Function SextaFeiraSanta(ByVal Ano As Integer) As Date
        Dim D As Date = Pascoa(Ano)
        Return DateSerial(Ano, D.Month, D.Day - 2)
    End Function

    Public Function Pascoa(ByVal Ano As Integer) As Date

        Dim A As Integer = Ano Mod 19
        Dim B As Integer = Int(Ano / 100)
        Dim C As Integer = Ano Mod 100
        Dim D As Integer = Int(B / 4)
        Dim E As Integer = B Mod 4
        Dim F As Integer = Int((B + 8) / 25)
        Dim G As Integer = Int((B - F + 1) / 3)
        Dim H As Integer = (19 * A + B - D - G + 15) Mod 30
        Dim I As Integer = Int(C / 4)
        Dim J As Integer = C Mod 4
        Dim L As Integer = (32 + 2 * E + 2 * I - H - J) Mod 7
        Dim M As Integer = Int((A + 11 + H + 22 * L) / 451)

        Dim Mes As Integer = Int((H + L - 7 * M + 114) / 31)
        Dim Dia As Integer = 1 + ((H + L - 7 * M + 114) Mod 31)

        Return DateSerial(Ano, Mes, Dia)
    End Function

    Public Function CorpoDeDeus(ByVal Ano As Integer) As Date
        Dim D As Date = Pascoa(Ano)
        Return DateSerial(Ano, D.Month, D.Day + 60)
    End Function


End Module
