﻿Imports System.IO
Imports System.Xml
Imports System.Text
Imports System.Security.Cryptography

Public Class frmSettings
    ''' <summary>
    ''' Quando abrimos a form, lemos a configuração e preenchemos as caixas de texto
    ''' depois copiamos os valores das caixas de texto para as variaveis globais
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Settings_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            'subLerConfig()
            subValores2Caixas()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Abre a form para escolher o servidor SQL
    ''' Cria a base de dados
    ''' Cria as tabelas
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSQL_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSQL.Click
        frmSqlServer.Show()
        frmSqlServer.Focus()
    End Sub
    ''' <summary>
    ''' Vamos gravar os valores que estão nas caixas de texto nas variaveis globais 
    ''' e no ficheiro de configuração
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnGravar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGravar.Click
        Try
            If funTestaValores() Then
                ' SQL
                Settings.strDataSouce = txbNomeServidorSQL.Text.Trim
                Settings.bolAutenticaçãoSqlServer = radAutenticaçãoSqlServer.Checked
                Settings.bolAutenticaçãoSqlWindows = radAutenticaçãoWindows.Checked
                Settings.strSqlLogin = txbLogin.Text
                Settings.strSqlPassword = txbPassword.Text
                Settings.strFicheiroBackupDBSql = txbFicheiroBackupDBSql.Text

                ' Empresa
                Settings.strNomeEmpresa = txbNomeEmpresa.Text.Trim
                Settings.strMoradaEmpresa = txbMorada.Text.Trim
                Settings.strCódigoPostalEmpresa = mtbCódigoPostal.Text.Trim
                Settings.strLocalidadeEmpresa = txbLocalidade.Text.Trim

                ' Taxas Sociais
                Settings.sglTaxaSegSocialSócioEmpresa = Convert.ToSingle(txbTaxaSegSocialSócioEmpresa.Text.Replace("%", "").Trim)
                Settings.sglTaxaSegSocialFuncionárioEmpresa = Convert.ToSingle(txbTaxaSegSocialFuncionárioEmpresa.Text.Replace("%", "").Trim)
                Settings.sglTaxaSegSocialSócio = Convert.ToSingle(txbTaxaSegSocialSócio.Text.Replace("%", "").Trim)
                Settings.sglTaxaSegSocialFuncionário = Convert.ToSingle(txbTaxaSegSocialFuncionário.Text.Replace("%", "").Trim)
                Settings.sglTaxaIRP = Convert.ToSingle(txbTaxaIRP.Text.Replace("%", "").Trim)

                ' Número Horas
                Settings.intNúmeroHorasSemanais = Int(txbNúmeroHorasSemanais.Text.Trim)
                Settings.intNúmeroHorasDiárias = Int(txbNúmeroHorasDiárias.Text.Trim)

                subGravarConfig()
                subValores2Caixas()
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub btnBackupBaseDados_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnBackupBaseDados.Click
        subBackupBaseDados()
    End Sub

    ''' <summary>
    ''' Esta rotina grava num ficheiro XML as configurações do programa
    ''' Também podia gravar uma parte da base de dados SQL, mas assim é mais fácil de alterar
    ''' e há configurações, por exemplo: do servidor SQL que não podem ser guardadas na base de dados, 
    ''' não é possível aceder a um servidor se não sabemos a qual nem a que base de dados
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub subGravarConfig()
        If My.Computer.FileSystem.DirectoryExists("C:\CSC-EA\") = False Then
            My.Computer.FileSystem.CreateDirectory("C:\CSC-EA\")
        End If
        If My.Computer.FileSystem.DirectoryExists("C:\CSC-EA\Salários\") = False Then
            My.Computer.FileSystem.CreateDirectory("C:\CSC-EA\Salários\")
        End If
        Dim xmlw As New XmlTextWriter("C:\CSC-EA\Salários\Config.xml", System.Text.Encoding.UTF8)
        Try
            ' Cria um novo ficheiro XML com a codificação UTF8
            xmlw.Formatting = Formatting.Indented

            xmlw.WriteStartDocument()

            ' Adiciona um comentário geral
            xmlw.WriteComment("ConfiguraçãoGeral")

            ' Criar um elemento geral
            xmlw.WriteStartElement("Config")

            ' Criar o elemento "Dados SQL" e alguns dados
            With xmlw
                .WriteStartElement("DadosSQL")
                .WriteElementString("SQLServer", Settings.strDataSouce)
                .WriteElementString("AutenticaçãoSqlWindows", Settings.bolAutenticaçãoSqlWindows.ToString)
                .WriteElementString("AutenticaçãoSqlServer", Settings.bolAutenticaçãoSqlServer.ToString)
                .WriteElementString("SqlLogin", funEncrypt(Settings.strSqlLogin))
                .WriteElementString("SqlPassword", funEncrypt(Settings.strSqlPassword))
                .WriteElementString("FicheiroBackupDBSql", Settings.strFicheiroBackupDBSql)
                .WriteEndElement()
            End With

            ' Criar o elemento "Dados Empresa" e alguns dados
            With xmlw
                .WriteStartElement("DadosEmpresa")
                .WriteElementString("Nome", Settings.strNomeEmpresa)
                .WriteElementString("Morada", Settings.strMoradaEmpresa)
                .WriteElementString("CódigoPostal", Settings.strCódigoPostalEmpresa)
                .WriteElementString("Localidade", Settings.strLocalidadeEmpresa)
                .WriteEndElement()
            End With

            ' Criar o elemento "Configurações impostas pela Lei Portuguesa" e alguns dados
            With xmlw
                .WriteStartElement("ConfiguraçõesLei")
                .WriteElementString("NúmeroHorasSemanais", Settings.intNúmeroHorasSemanais.ToString)
                .WriteElementString("NúmeroHorasDiárias", Settings.intNúmeroHorasDiárias.ToString)
                .WriteElementString("TaxaSegSocialSócioEmpresa", Settings.sglTaxaSegSocialSócioEmpresa.ToString)
                .WriteElementString("TaxaSegSocialFuncionárioEmpresa", Settings.sglTaxaSegSocialFuncionárioEmpresa.ToString)
                .WriteElementString("TaxaSegSocialSócio", Settings.sglTaxaSegSocialSócio.ToString)
                .WriteElementString("TaxaSegSocialFuncionário", Settings.sglTaxaSegSocialFuncionário.ToString)
                .WriteElementString("TaxaRendimentosPredidais", Settings.sglTaxaIRP.ToString)
                .WriteEndElement()
            End With

            xmlw.WriteEndElement() ' <- config
            xmlw.WriteEndDocument()

        Catch ex As Exception
            MsgBox("Settings: subGravarConfig -> " + ex.Message, MsgBoxStyle.Critical, "Erro a Gravar Configuração")
            modLog.subErro(ex)
        Finally
            ' Fecha o documento XML
            xmlw.Flush()
            xmlw.Close()
        End Try
    End Sub
    ''' <summary>
    ''' Esta rotina tenta ler a configuração, 
    ''' se não conseguir mete valores de defeito nas variáveis
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub subLerConfig()
        Try
            Dim xmlFile = XDocument.Load("C:\CSC-EA\Salários\Config.xml")

            ' Dados SQL
            Settings.strDataSouce = xmlFile...<SQLServer>.Value
            Settings.bolAutenticaçãoSqlWindows = (xmlFile...<AutenticaçãoSqlWindows>.Value.ToString.Trim = "True")
            Settings.bolAutenticaçãoSqlServer = (xmlFile...<AutenticaçãoSqlServer>.Value.ToString.Trim = "True")
            Settings.strSqlLogin = funDecrypt(xmlFile...<SqlLogin>.Value)
            Settings.strSqlPassword = funDecrypt(xmlFile...<SqlPassword>.Value)
            Settings.strFicheiroBackupDBSql = xmlFile...<FicheiroBackupDBSql>.Value

            ' Dados Empresa
            Settings.strNomeEmpresa = xmlFile...<Nome>.Value
            Settings.strMoradaEmpresa = xmlFile...<Morada>.Value
            Settings.strCódigoPostalEmpresa = xmlFile...<CódigoPostal>.Value
            Settings.strLocalidadeEmpresa = xmlFile...<Localidade>.Value

            ' Configurações impostas pela Lei Portuguesa
            Settings.intNúmeroHorasSemanais = Int(xmlFile...<NúmeroHorasSemanais>.Value)
            Settings.intNúmeroHorasDiárias = Int(xmlFile...<NúmeroHorasDiárias>.Value)
            Settings.sglTaxaSegSocialSócioEmpresa = Convert.ToSingle(xmlFile...<TaxaSegSocialSócioEmpresa>.Value) '/ 100
            Settings.sglTaxaSegSocialFuncionárioEmpresa = Convert.ToSingle(xmlFile...<TaxaSegSocialFuncionárioEmpresa>.Value) '/ 100
            Settings.sglTaxaSegSocialSócio = Convert.ToSingle(xmlFile...<TaxaSegSocialSócio>.Value) '/ 100
            Settings.sglTaxaSegSocialFuncionário = Convert.ToSingle(xmlFile...<TaxaSegSocialFuncionário>.Value) '/ 100
            Settings.sglTaxaIRP = Convert.ToSingle(xmlFile...<TaxaRendimentosPredidais>.Value) '/ 100
        Catch ex As Exception
            If strDataSouce = "" Then
                Dim resposta As Integer = MsgBox("Não foi possível ler o ficheiro de configuração", MsgBoxStyle.YesNo, "Quer carregar os valores de defeito")
                If resposta = vbYes Then
                    Settings.intNúmeroHorasSemanais = 40
                    Settings.intNúmeroHorasDiárias = 8
                    Settings.sglTaxaSegSocialSócioEmpresa = 31.25
                    Settings.sglTaxaSegSocialFuncionárioEmpresa = 34.75
                    Settings.sglTaxaSegSocialSócio = 10.0
                    Settings.sglTaxaSegSocialFuncionário = 11.0
                    Settings.sglTaxaIRP = 15.0
                End If
            Else
                modLog.subErro(ex)
            End If
        Finally
            strSQLConnection = "Data Source=" & strDataSouce & ";"
            strSQLConnection += "Database=Funcionários;"
            If bolAutenticaçãoSqlWindows Then
                strSQLConnection += "Integrated Security=SSPI;"
            Else
                strSQLConnection += "User ID=" & strSqlLogin & ";"
                strSQLConnection += "Password=" & strSqlPassword & ";"
            End If
        End Try
    End Sub
    ''' <summary>
    ''' Copia os valores para as caixas de texto e formata-as
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subValores2Caixas()
        Try

            ' SQL
            txbNomeServidorSQL.Text = Settings.strDataSouce
            radAutenticaçãoSqlServer.Checked = Settings.bolAutenticaçãoSqlServer
            radAutenticaçãoWindows.Checked = Settings.bolAutenticaçãoSqlWindows
            txbLogin.Text = Settings.strSqlLogin
            txbPassword.Text = Settings.strSqlPassword
            txbFicheiroBackupDBSql.Text = Settings.strFicheiroBackupDBSql

            'txbNomeServidorSQL.Enabled = False
            'radAutenticaçãoSqlServer.Enabled = False
            'radAutenticaçãoWindows.Enabled = False
            'txbLogin.Enabled = False
            'txbPassword.Enabled = False

            ' Empresa
            txbNomeEmpresa.Text = Settings.strNomeEmpresa
            txbMorada.Text = Settings.strMoradaEmpresa
            mtbCódigoPostal.Text = Settings.strCódigoPostalEmpresa
            txbLocalidade.Text = Settings.strLocalidadeEmpresa

            ' Taxas Sociais
            txbTaxaSegSocialSócioEmpresa.Text = (Settings.sglTaxaSegSocialSócioEmpresa / 100).ToString("#,##0.00 %")
            txbTaxaSegSocialFuncionárioEmpresa.Text = (Settings.sglTaxaSegSocialFuncionárioEmpresa / 100).ToString("#,##0.00 %")
            txbTaxaSegSocialSócio.Text = (Settings.sglTaxaSegSocialSócio / 100).ToString("#,##0.00 %")
            txbTaxaSegSocialFuncionário.Text = (Settings.sglTaxaSegSocialFuncionário / 100).ToString("#,##0.00 %")
            txbTaxaIRP.Text = (Settings.sglTaxaIRP / 100).ToString("#,##0.00 %")

            ' Número Horas
            txbNúmeroHorasSemanais.Text = Settings.intNúmeroHorasSemanais.ToString
            txbNúmeroHorasDiárias.Text = Settings.intNúmeroHorasDiárias
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Função de teste de valores a ser guardados
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function funTestaValores()
        Try
            If txbNomeServidorSQL.Text.Trim = "" Then
                MsgBox("Nome do servidor SQL inválido")
                Return False
            End If

            If IsNumeric(txbTaxaSegSocialSócioEmpresa.Text.Replace("%", "").Trim) Then
                If Convert.ToSingle(txbTaxaSegSocialSócioEmpresa.Text.Replace("%", "").Trim) < 0 Then
                    MsgBox("Taxa de segurança social do sócio pago pela empresa é negativa.")
                    Return False
                End If
            Else
                MsgBox("Taxa de segurança social do sócio pago pela empresa, não é número!")
                Return False
            End If
            If IsNumeric(txbTaxaSegSocialFuncionárioEmpresa.Text.Replace("%", "").Trim) Then
                If Convert.ToSingle(txbTaxaSegSocialFuncionárioEmpresa.Text.Replace("%", "").Trim) < 0 Then
                    MsgBox("Taxa de segurança social do funcionário pago pela empresa é negativa.")
                    Return False
                End If
            Else
                MsgBox("Taxa de segurança social do funcionário pago pela empresa, não é número!")
                Return False
            End If
            If IsNumeric(txbTaxaSegSocialSócio.Text.Replace("%", "").Trim) Then
                If Convert.ToSingle(txbTaxaSegSocialSócio.Text.Replace("%", "").Trim) < 0 Then
                    MsgBox("Taxa de segurança social do sócio pago pelo funcionário é negativa.")
                    Return False
                End If
            Else
                MsgBox("Taxa de segurança social do sócio pago pelo funcionário, não é número!")
                Return False
            End If
            If IsNumeric(txbTaxaSegSocialFuncionário.Text.Replace("%", "").Trim) Then
                If Convert.ToSingle(txbTaxaSegSocialFuncionário.Text.Replace("%", "").Trim) < 0 Then
                    MsgBox("Taxa de segurança social do funcionário pago pelo funcionário é negativa.")
                    Return False
                End If
            Else
                MsgBox("Taxa de segurança social do funcionário pago pelo funcionário, não é número!")
                Return False
            End If

            If IsNumeric(txbNúmeroHorasSemanais.Text.Trim) Then
                If Int(txbNúmeroHorasSemanais.Text.Trim) < 0 Then
                    MsgBox("Número de horas semanais, é negativo.")
                    Return False
                End If
            Else
                MsgBox("Número de horas semanais, não é número.")
                Return False
            End If
            If IsNumeric(txbNúmeroHorasDiárias.Text.Trim) Then
                If Int(txbNúmeroHorasDiárias.Text.Trim) < 0 Then
                    MsgBox("Número de horas diárias, é negativo.")
                    Return False
                End If
            Else
                MsgBox("Número de horas diárias, não é número.")
                Return False
            End If

            Return True
        Catch ex As Exception
            modLog.subErro(ex)
            Return False
        End Try
    End Function
    Private Sub subBackupBaseDados()
        Settings.strFicheiroBackupDBSql = txbFicheiroBackupDBSql.Text
        Dim sqlConnBackupDB As New SqlConnection(Settings.strSQLConnection)
        Dim cmdBackupDB As SqlCommand
        Dim strBackupDB As String = "BACKUP DATABASE Funcionários"
        If txbFicheiroBackupDBSql.Text <> "" Then strBackupDB += " TO DISK='" & txbFicheiroBackupDBSql.Text & "'"
        Try
            sqlConnBackupDB.Open()
            cmdBackupDB = New SqlCommand(strBackupDB, sqlConnBackupDB)
            cmdBackupDB.ExecuteNonQuery() ' Cria Tabela Funcionários
            MsgBox("Backup executado com sucesso!")
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Exclamation, "Erro a executar backup!")
        End Try
    End Sub

    'The function used to encrypt the text
    Private Function funEncrypt(ByVal strText As String) As String
        Dim byKey() As Byte = System.Text.Encoding.UTF8.GetBytes("&%#@?,:*")
        Dim IV() As Byte = {&H12, &H34, &H56, &H78, &H90, &HAB, &HCD, &HEF}
        Try
            Dim des As New DESCryptoServiceProvider()
            Dim inputByteArray() As Byte = Encoding.UTF8.GetBytes(strText)
            Dim ms As New MemoryStream()
            Dim cs As New CryptoStream(ms, des.CreateEncryptor(byKey, IV), CryptoStreamMode.Write)
            cs.Write(inputByteArray, 0, inputByteArray.Length)
            cs.FlushFinalBlock()
            Return Convert.ToBase64String(ms.ToArray())
        Catch ex As Exception
            modLog.subErro(ex)
            Return ex.Message
        End Try
    End Function
    'The function used to decrypt the text
    Private Function funDecrypt(ByVal strText As String) As String
        Dim byKey() As Byte = System.Text.Encoding.UTF8.GetBytes("&%#@?,:*")
        Dim IV() As Byte = {&H12, &H34, &H56, &H78, &H90, &HAB, &HCD, &HEF}
        Dim inputByteArray(strText.Length) As Byte
        Try
            Dim des As New DESCryptoServiceProvider()
            inputByteArray = Convert.FromBase64String(strText)
            Dim ms As New MemoryStream()
            Dim cs As New CryptoStream(ms, des.CreateDecryptor(byKey, IV), CryptoStreamMode.Write)
            cs.Write(inputByteArray, 0, inputByteArray.Length)
            cs.FlushFinalBlock()
            Dim encoding As System.Text.Encoding = System.Text.Encoding.UTF8
            Return encoding.GetString(ms.ToArray())
        Catch ex As Exception
            modLog.subErro(ex)
            Return ex.Message
        End Try
    End Function

End Class

