﻿Imports Microsoft.SqlServer.Management
Imports Microsoft.SqlServer.Management.Smo
Imports Microsoft.SqlServer.Management.Sdk

Public Class frmSqlServer
    ''' <summary>
    ''' Quando arrancar a form, carregamos a lista de servidores
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frmSqlServer_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            radAutenticaçãoSqlServer.Checked = Settings.bolAutenticaçãoSqlServer
            radAutenticaçãoWindows.Checked = Settings.bolAutenticaçãoSqlWindows
            txbLogin.Text = Settings.strSqlLogin
            txbPassword.Text = Settings.strSqlPassword
            txbLogin.Enabled = radAutenticaçãoSqlServer.Checked
            txbPassword.Enabled = radAutenticaçãoSqlServer.Checked
            subListaServers()

            cmbServer.SelectedIndex = cmbServer.FindString(Settings.strDataSouce)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos mostrar todas as bases de dados registadas no servidor seleccionado
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub cmbServer_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbServer.SelectedIndexChanged
        Try
            subListaBasesDados()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos actualizar a lista de servidores
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnActualizar_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnActualizar.Click
        Try
            subListaServers()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos testar a ligação à base de dados com a configuração actual
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnTestarLigação_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTestarLigação.Click
        Try
            If cmbServer.SelectedIndex <> -1 Then
                Dim strConnString As String = ""
                strConnString = "Data Source=" & cmbServer.SelectedItem.ToString & ";"
                If radAutenticaçãoWindows.Checked Then
                    strConnString += "Integrated Security=SSPI;"
                Else
                    strConnString += "User ID=" & txbLogin.Text & ";"
                    strConnString += "Password=" & txbPassword.Text & ";"
                End If
                Dim sqlConnDB As SqlConnection = New SqlConnection(strConnString)

                sqlConnDB.Open()
                If sqlConnDB.State <> ConnectionState.Open Then
                    MsgBox("Erro a abrir ligação!", MsgBoxStyle.Critical, "Salários - SQL Server")
                Else
                    sqlConnDB.Close()
                    MsgBox("Ligação correcta.", MsgBoxStyle.Information, "Salários - SQL Server")
                End If
            Else
                MsgBox("Nenhum servidor seleccionado!", MsgBoxStyle.Information, "Seleccione um servidor")
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub btnExecutarCmdSql_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnExecutarCmdSql.Click
        frmCmdSql.Show()
        frmCmdSql.Focus()
    End Sub

    ''' <summary>
    ''' Vamos criar a base de dados no servidor
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnCriarBaseDados_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCriarBaseDados.Click
        Try
            subCriarBaseDados()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Sempre que o utilizador alterar o tipo de autenticação permitimos ou não alterar os dados de login
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub radAutenticaçãoSqlServer_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles radAutenticaçãoSqlServer.CheckedChanged, radAutenticaçãoWindows.CheckedChanged
        txbLogin.Enabled = radAutenticaçãoSqlServer.Checked
        txbPassword.Enabled = radAutenticaçãoSqlServer.Checked
    End Sub

    ''' <summary>
    ''' Preenchemos a ComboBox com todos os servidores SQL acessiveis
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subListaServers()
        Try
            Dim s() As clsSqlServer.ServerInstance
            s = clsSqlServer.EnumerateServers()
            cmbServer.Items.Clear()
            If s.Length > 0 Then
                For i = 0 To s.Length - 1
                    cmbServer.Items.Add(s(i).Name)
                Next
            Else
                MsgBox("Não foi possível encontrar nenhum servidor SQL!", MsgBoxStyle.Critical)
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub subCriarBaseDados()
        Dim bolDBCriada As Boolean = False
        Dim strConnString As String = ""
        strConnString = "Data Source=" & cmbServer.SelectedItem.ToString & ";"
        If radAutenticaçãoWindows.Checked Then
            strConnString += "Integrated Security=SSPI;"
        Else
            strConnString += "User ID=" & txbLogin.Text & ";"
            strConnString += "Password=" & txbPassword.Text & ";"
        End If
        Dim sqlConnDB As SqlConnection = New SqlConnection(strConnString)
        Dim strCreateDB As String = ""
        strCreateDB += "CREATE DATABASE Funcionários "
        'strCreateDB += "ON " 'PRIMARY"
        'strCreateDB += "(NAME=Funcionários, "
        'strCreateDB += "FILENAME='Funcionários.mdf', "
        'strCreateDB += "SIZE=3, MAXSIZE=UNLIMITED, FILEGROWTH=10%) "
        'strCreateDB += "LOG ON "
        'strCreateDB += "(NAME=Funcionários_log, "
        'strCreateDB += "FILENAME='Funcionários.ldf', "
        'strCreateDB += "SIZE=1, MAXSIZE=UNLIMITED,FILEGROWTH=10%)"

        txbLog.Text = strCreateDB

        sqlConnDB.Open()
        If sqlConnDB.State <> ConnectionState.Open Then
            Throw New Exception("Erro a abrir ligação")
        Else
            sqlConnDB.Close()
        End If

        Dim sqlCmdCreateDB As SqlCommand = New SqlCommand(strCreateDB, sqlConnDB)
        Try
            sqlConnDB.Open()
            sqlCmdCreateDB.ExecuteNonQuery()
            bolDBCriada = True
            'MsgBox("Base de dados criada com sucesso!")
        Catch ex As Exception
            MsgBox("Não foi possível criar a base de dados!" & vbNewLine & "Erro: " & ex.Message)
        Finally
            If sqlConnDB.State = ConnectionState.Open Then
                sqlConnDB.Close()
            End If
        End Try
        If bolDBCriada Then
            txbLog.Text = "Base de dados registada com sucesso."
            subGravarConfiguração()
            subCriarTabelas()
            subListaBasesDados()
        End If
    End Sub
    Private Sub subCriarTabelas()
        Try
            ' Criação da tabela Funcionários
            Dim strCriaFuncionários As String = ""
            strCriaFuncionários += "CREATE TABLE Funcionários ( "
            strCriaFuncionários += "NúmeroFuncionário nchar(10), "
            strCriaFuncionários += "Nome nchar(100), "
            strCriaFuncionários += "Função nchar(50), "
            strCriaFuncionários += "SócioEmpresa nchar(5), "
            strCriaFuncionários += "NúmeroSegSocial nchar(15), "
            strCriaFuncionários += "NIF nchar(12), "
            strCriaFuncionários += "NIB nchar(22), "
            strCriaFuncionários += "AdmitidoEm date, "
            strCriaFuncionários += "RescindiuAfirmativo nchar(10), "
            strCriaFuncionários += "RescindiuEm date ) "

            ' Criação da tabela Mês
            Dim strCriaMês As String = ""
            strCriaMês += "CREATE TABLE Mês ( "
            strCriaMês += "NúmeroFuncionário nchar(10), "
            strCriaMês += "Ano int, "
            strCriaMês += "Mês int, "
            strCriaMês += "VencimentoBase real, "
            strCriaMês += "SubRefeição real, "
            strCriaMês += "DiasMês int, "
            strCriaMês += "DiasSubRefeição int, "
            strCriaMês += "DiasFérias int, "
            strCriaMês += "DiasBaixa int, "
            strCriaMês += "DiasFaltas int, "
            strCriaMês += "TaxaIRS real ) "

            ' Criação da tabela HorasExtras
            Dim strCriaHorasExtras As String = ""
            strCriaHorasExtras += "CREATE TABLE HorasExtras ( "
            strCriaHorasExtras += "NúmeroFuncionário nchar(10), "
            strCriaHorasExtras += "Ano int, "
            strCriaHorasExtras += "Mês int, "
            strCriaHorasExtras += "Dia int, "
            strCriaHorasExtras += "NúmeroHoras real, "
            strCriaHorasExtras += "ValorHoraNormal real, "
            strCriaHorasExtras += "Percentagem real ) "

            ' Criação da tabela TotalHorasExtras
            Dim strCriaTotalHorasExtras As String = ""
            strCriaTotalHorasExtras += "CREATE TABLE TotalHorasExtras ( "
            strCriaTotalHorasExtras += "NúmeroFuncionário nchar(10), "
            strCriaTotalHorasExtras += "Ano int, "
            strCriaTotalHorasExtras += "Mês int, "
            strCriaTotalHorasExtras += "Dia int, "
            strCriaTotalHorasExtras += "Total real) "

            ' Criação da tabela TotalMês
            Dim strCriaTotalMês As String = ""
            strCriaTotalMês += "CREATE TABLE TotalMês ( "
            strCriaTotalMês += "NúmeroFuncionário nchar(10), "
            strCriaTotalMês += "Ano int, "
            strCriaTotalMês += "Mês int, "
            strCriaTotalMês += "SujeitoDescontos real, "
            strCriaTotalMês += "TaxaIRS real, "
            strCriaTotalMês += "DescontoIRS real) "

            ' Criação da tabela TotalMês
            Dim strCriaRendas As String = ""
            strCriaRendas += "CREATE TABLE Rendas ( "
            strCriaRendas += "Designação nchar(50), "
            strCriaRendas += "Ano int, "
            strCriaRendas += "Mês int, "
            strCriaRendas += "Valor real) "

            ' Criação efectiva
            Dim sqlConnCriarTabelas As New SqlConnection(Settings.strSQLConnection)
            Dim cmdCriarTabela As SqlCommand
            sqlConnCriarTabelas.Open()
            cmdCriarTabela = New SqlCommand(strCriaFuncionários, sqlConnCriarTabelas)
            cmdCriarTabela.ExecuteNonQuery() ' Cria Tabela Funcionários
            cmdCriarTabela = New SqlCommand(strCriaMês, sqlConnCriarTabelas)
            cmdCriarTabela.ExecuteNonQuery() ' Cria Tabela Mês
            cmdCriarTabela = New SqlCommand(strCriaHorasExtras, sqlConnCriarTabelas)
            cmdCriarTabela.ExecuteNonQuery() ' Cria Tabela Horas Extras
            cmdCriarTabela = New SqlCommand(strCriaTotalHorasExtras, sqlConnCriarTabelas)
            cmdCriarTabela.ExecuteNonQuery() ' Cria Tabela Total Horas Extras
            cmdCriarTabela = New SqlCommand(strCriaTotalMês, sqlConnCriarTabelas)
            cmdCriarTabela.ExecuteNonQuery() ' Cria Tabela Total Mês
            cmdCriarTabela = New SqlCommand(strCriaRendas, sqlConnCriarTabelas)
            cmdCriarTabela.ExecuteNonQuery() ' Cria Tabela Rendas
            sqlConnCriarTabelas.Close()
            txbLog.Text += vbNewLine & "Base de dados criada com sucesso."
        Catch ex As Exception
            modLog.subErro(ex)
            txbLog.Text += vbNewLine & "Erro ao criar a base de dados."
        End Try
    End Sub
    Private Sub subGravarConfiguração()
        Try
            Settings.strDataSouce = cmbServer.SelectedItem.ToString
            Settings.bolAutenticaçãoSqlServer = radAutenticaçãoSqlServer.Checked
            Settings.bolAutenticaçãoSqlWindows = radAutenticaçãoWindows.Checked
            Settings.strSqlLogin = txbLogin.Text
            Settings.strSqlPassword = txbPassword.Text
            frmSettings.subGravarConfig()
            frmSettings.subLerConfig()
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub subListaBasesDados()
        Try
            lstDatabases.Items.Clear()
            If cmbServer.SelectedIndex <> -1 Then
                Dim serverName As String = cmbServer.SelectedItem.ToString
                Dim server As Server = New Server(serverName)
                Try
                    For Each database As Database In server.Databases
                        lstDatabases.Items.Add(database.Name)
                    Next
                Catch ex As Exception
                    modLog.subErro(ex)
                End Try
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
End Class