﻿Imports System.Math
Imports System.Drawing.Printing ' De acordo com toturial de: http://www.macoratti.net/08/04/vbn8_imp.htm
''' <summary>
''' Form para previsualizar os dados relativos declaração de descontos IRS.
''' e posterior impressão dos mesmos
''' </summary>
''' <remarks></remarks>
Public Class frmDeclaraçãoDescontosIRS
    ' Variaveis Globais
    Dim intDiasTotaisMês As Integer
    Dim intDiasÚteis As Integer
    Dim strMês As String ' Mês actual ou "Férias" ou "Natal"
    Dim intRowActual As Integer = 0
    Dim sglTotalDescontoIRS As Single = 0.0
    Dim strTipoImpressão As String
    Dim bolFimLoad As Boolean = False ' Indica que já acabou de fazer load, pelo que o programa (ou consultas) já pode aceder a todos os objectos da form

    'Variaveis das margens
    Dim sglMargemEsquerda As Single
    Dim sglMargemSuperior As Single
    Dim sglMargemDireita As Single
    Dim sglMargemInferior As Single

    ' Variaveis das canetas
    Dim penCinza3 As Pen = New Pen(Color.Gray, 3)
    Dim penPreta2 As Pen = New Pen(Color.Black, 2)

    'Variaveis das fontes
    Dim fntNomeEmpresa As Font = New Font("Arial", 20, FontStyle.Bold)
    Dim fntMoradaEmpresa As Font = New Font("Arial", 14)
    Dim fntTítulo As Font = New Font("Arial", 14, FontStyle.Bold Or FontStyle.Underline)
    Dim fntDados As Font = New Font("Arial", 10, FontStyle.Bold) 'Or FontStyle.Underline)
    Dim fntTexto As Font = New Font("Arial", 10)
    Dim fntOutros As Font = New Font("Arial", 8)

    ' Alinhamento à direita
    Dim sfDireita As New Drawing.StringFormat
    Dim sfCentro As New Drawing.StringFormat

    ' Cotas
    Dim x As Single = 0.0
    Dim y As Single = 0.0
    Dim sglColunaMês As Single
    Dim sglColunaTaxa As Single
    Dim sglColunaX As Single
    Dim sglColunaSujeitoImposto As Single
    Dim sglColunaDescontosIRS As Single
    Dim sglEspaçoLinha As Single


    ''' <summary>
    ''' Rotina executada quando carrega a Form.
    ''' Selecciona o dia actual e formata no calendário 
    ''' A seguir carrega os valores relativos ao mês actual para a tabela e calculas os totais do mês
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frmRetençãoImpostos_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            strMês = Today.Month.ToString
            calMês.SelectDate(Today)
            subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
            subCarregaValoresAno(Today.Month.ToString)
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            dgvFuncionários.ReadOnly = False
            dgvFuncionários.Columns(colImprimir.Index).ReadOnly = False
            chkContabilidade.Checked = True
            chkFuncionário.Checked = True
            chkArquivo.Checked = True
            bolFimLoad = True
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador alterou o mês do calendário
    ''' Carregamos os dados para o novo mês e recalculamos os totais
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub calMês_MonthChanged(ByVal sender As System.Object, ByVal e As Pabo.Calendar.MonthChangedEventArgs) Handles calMês.MonthChanged
        Try
            If bolFimLoad Then
                strMês = calMês.ActiveMonth.Month.ToString
                subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
                subCarregaValoresAno(calMês.ActiveMonth.Month.ToString)
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos imprimir os recibos directo para a impressora
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnImprimir_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnImprimir.Click
        intRowActual = 0
        If (intRowActual + 1 < dgvFuncionários.Rows.Count - 1) Then
            If chkContabilidade.Checked Then
                strTipoImpressão = "Contabilidade"
            ElseIf chkFuncionário.Checked Then
                strTipoImpressão = "Funcionário"
            ElseIf chkArquivo.Checked Then
                strTipoImpressão = "Arquivo"
            Else
                MsgBox("Tem que ter activa pelo menos um tipo de cópia: Contabilidade, Funcionário ou Arquivo")
                Exit Sub
            End If

            Dim bolImprimir As Boolean
            For Each row As DataGridViewRow In dgvFuncionários.Rows
                bolImprimir = bolImprimir Or dgvFuncionários.Rows(row.Index).Cells(colImprimir.Index).Value
            Next

            If bolImprimir AndAlso (intRowActual + 1 < dgvFuncionários.Rows.Count - 1) Then
                subImprimir()
            Else
                MsgBox("Tem que ter activo pelo menos um funcionário na tabela")
            End If
        End If
    End Sub
    ''' <summary>
    ''' Cria a ordem de impressão
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subImprimir()

        For i As Integer = 0 To dgvFuncionários.Rows.Count - 1
            If dgvFuncionários.Rows(i).Cells(colImprimir.Index).Value Then
                intRowActual = i
                Exit For
            End If
        Next

        'define os objetos printdocument e os eventos associados
        Dim pdReciboVencimento As Printing.PrintDocument = New Printing.PrintDocument()

        'IMPORTANTE - definimos 3 eventos para tratar a impressão : PringPage, BeginPrint e EndPrint.
        AddHandler pdReciboVencimento.PrintPage, New Printing.PrintPageEventHandler(AddressOf Me.pdRelatorios_PrintPage)
        AddHandler pdReciboVencimento.BeginPrint, New Printing.PrintEventHandler(AddressOf Me.Begin_Print)
        AddHandler pdReciboVencimento.EndPrint, New Printing.PrintEventHandler(AddressOf Me.End_Print)

        'define o objeto para visualizar a impressao
        Dim objPrintPreview As New PrintPreviewDialog

        Try
            'define o formulário como maximizado e com Zoom
            With objPrintPreview
                .Document = pdReciboVencimento
                .WindowState = FormWindowState.Maximized
                .PrintPreviewControl.Zoom = 1
                .Text = "Declaração de Descontos IRS: " & calMês.ActiveMonth.Year.ToString
                .ShowDialog()
            End With
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Começa a imprimir, não temos nada a fazer nesta parte, mas fica aqui para se no futuro necessitar de abrir ligações SQL
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Begin_Print(ByVal sender As Object, ByVal e As Printing.PrintEventArgs)
    End Sub
    ''' <summary>
    ''' Construção das páginas a imprimir
    ''' Desenhamos os recibos
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub pdRelatorios_PrintPage(ByVal sender As System.Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs)
        Try
            ' Margen
            sglMargemEsquerda = e.MarginBounds.Left
            sglMargemSuperior = e.MarginBounds.Top
            sglMargemDireita = e.MarginBounds.Right
            sglMargemInferior = e.MarginBounds.Bottom

            ' Alinhamento à direita
            sfDireita.Alignment = StringAlignment.Far
            ' Alinhamento ao centro
            sfCentro.Alignment = StringAlignment.Center

            sglColunaMês = sglMargemEsquerda + 100.0
            sglColunaTaxa = sglColunaMês + 200.0
            sglColunaX = sglColunaTaxa + 10.0
            sglColunaSujeitoImposto = sglColunaX + 100.0
            sglColunaDescontosIRS = sglMargemDireita - 100.0
            sglEspaçoLinha = 19.0

            subPrintCabeçalhoFolha(e.Graphics)
            subPrintCabeçalhoRelatório(e.Graphics)

            x = sglMargemEsquerda
            y += 50

            subCarregaValoresMês(dgvFuncionários.Rows(intRowActual).Cells(colNomeFuncionário.Index).Value)

            Dim strNome As String = dgvDados.Rows(calMês.ActiveMonth.Month - 1).Cells(colDadosNomeFuncionário.Index).Value
            Dim strNúmeroSegSocial As String = dgvDados.Rows(calMês.ActiveMonth.Month - 1).Cells(colDadosNúmeroSegSocial.Index).Value
            Dim strFunção As String = dgvDados.Rows(calMês.ActiveMonth.Month - 1).Cells(colDadosFunção.Index).Value
            Dim strNIF As String = dgvDados.Rows(calMês.ActiveMonth.Month - 1).Cells(colDadosNIF.Index).Value
            Dim strData As String = calMês.ActiveMonth.Year.ToString()

            subDesenhaString(e.Graphics, x, y, strNome, fntDados, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, ", inscrito na Segurança Social, sob o número", fntTexto, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, String.Format("{0:0 000 000 000}", Convert.ToUInt64(strNúmeroSegSocial)), fntDados, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, ", com a categoria profissional", fntTexto, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, strFunção, fntDados, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, "e Número de Contribuinte", fntTexto, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, String.Format("{0:000 000 000}", Convert.ToUInt64(strNIF)), fntDados, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, ", descontou durante o ano", fntTexto, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, strData, fntDados, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, "para IRS o valor", fntTexto, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, sglTotalDescontoIRS.ToString("#,##0.00 €"), fntDados, sglMargemEsquerda, sglMargemDireita)
            subDesenhaString(e.Graphics, x, y, ".", fntTexto, sglMargemEsquerda, sglMargemDireita)

            y += 50

            Dim intNúmeroMês As Integer = 0
            subPrintLinhaIRS(e.Graphics, "Janeiro", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Fevereiro", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Março", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Abril", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Maio", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Junho", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Julho", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Agosto", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Setembro", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Outubro", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Novembro", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Dezembro", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Subsídio Natal", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha
            intNúmeroMês += 1
            subPrintLinhaIRS(e.Graphics, "Subsídio Férias", Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosTaxaIRS.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosSujeitoDescontos.Index).Value), Convert.ToSingle(dgvDados.Rows(intNúmeroMês).Cells(colDadosDescontoIRS.Index).Value))
            y += sglEspaçoLinha

            subPrintRodapéIRS(e.Graphics, sglTotalDescontoIRS)

            If strTipoImpressão = "Contabilidade" Then
                y += 80
                x = 160
                e.Graphics.DrawString("Assinatura: __ __ __ __ __ __ __ __ __ __ __ __ __ __", fntTexto, Brushes.Black, x, y, New StringFormat)
            End If


            subPrintRodapéFolha(e.Graphics)

        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            e.HasMorePages = False

            If (intRowActual + 1 < dgvFuncionários.Rows.Count - 1) Then
                intRowActual += 1
                For i As Integer = intRowActual To dgvFuncionários.Rows.Count - 1
                    If dgvFuncionários.Rows(i).Cells(colImprimir.Index).Value Then
                        e.HasMorePages = True
                        intRowActual = i
                        Exit For
                    End If
                Next
            End If

            If strTipoImpressão = "Contabilidade" AndAlso Not e.HasMorePages Then
                If chkFuncionário.Checked Then
                    strTipoImpressão = "Funcionário"
                    For i As Integer = 0 To dgvFuncionários.Rows.Count - 1
                        If dgvFuncionários.Rows(i).Cells(colImprimir.Index).Value Then
                            e.HasMorePages = True
                            intRowActual = i
                            Exit For
                        End If
                    Next
                    e.HasMorePages = True
                ElseIf chkArquivo.Checked Then
                    strTipoImpressão = "Arquivo"
                    For i As Integer = 0 To dgvFuncionários.Rows.Count - 1
                        If dgvFuncionários.Rows(i).Cells(colImprimir.Index).Value Then
                            e.HasMorePages = True
                            intRowActual = i
                            Exit For
                        End If
                    Next
                    e.HasMorePages = True
                Else
                    e.HasMorePages = False
                End If
            End If

            If Not e.HasMorePages Then
                If strTipoImpressão = "Funcionário" AndAlso chkArquivo.Checked Then
                    strTipoImpressão = "Arquivo"
                    For i As Integer = 0 To dgvFuncionários.Rows.Count - 1
                        If dgvFuncionários.Rows(i).Cells(colImprimir.Index).Value Then
                            e.HasMorePages = True
                            intRowActual = i
                            Exit For
                        End If
                    Next
                    e.HasMorePages = True
                Else
                    e.HasMorePages = False
                End If
            End If
        End Try
    End Sub
    ''' <summary>
    ''' Fim de impressão, neste caso é só fim não temos que fazer nada
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="byvale"></param>
    ''' <remarks></remarks>
    Private Sub End_Print(ByVal sender As Object, ByVal byvale As Printing.PrintEventArgs)

    End Sub
    ''' <summary>
    ''' Desenha o cabeçalho da folha
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoFolha(ByVal g As Graphics)
        'Linhas 
        g.DrawLine(penCinza3, sglMargemEsquerda, 60, sglMargemDireita, 60)
        g.DrawLine(penCinza3, sglMargemEsquerda, 170, sglMargemDireita, 170)

        ' Variaveis da Empresa
        Dim strNomeEmpresa As String = Settings.strNomeEmpresa
        Dim strMorada As String = Settings.strMoradaEmpresa
        Dim strCódigoPostal As String = Settings.strCódigoPostalEmpresa
        Dim strLocalidade As String = Settings.strLocalidadeEmpresa

        Dim szfNomeEmpresa As SizeF = g.MeasureString(strNomeEmpresa, fntNomeEmpresa)
        Dim szfMorada As SizeF = g.MeasureString(strMorada, fntMoradaEmpresa)
        Dim szfCódigoPostal As SizeF = g.MeasureString(strCódigoPostal, fntMoradaEmpresa)
        Dim szfLocalidade As SizeF = g.MeasureString(strLocalidade, fntMoradaEmpresa)

        g.DrawString(strNomeEmpresa, fntNomeEmpresa, Brushes.Black, sglMargemEsquerda, 75, New StringFormat())
        g.DrawString(strMorada, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda, 75 + szfNomeEmpresa.Height, New StringFormat())
        g.DrawString(strCódigoPostal, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda, 75 + szfNomeEmpresa.Height + szfMorada.Height, New StringFormat())
        g.DrawString(strLocalidade, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda + szfCódigoPostal.Width, 75 + szfNomeEmpresa.Height + szfMorada.Height, New StringFormat())

        y = 150
        x = sglMargemDireita
        g.DrawString(strTipoImpressão, fntOutros, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha o cabeçalho do relatório
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoRelatório(ByVal g As Graphics)
        ' Desenha o Título Centrado
        Dim strTítulo As String = "Declaração de Descontos IRS: " & calMês.ActiveMonth.Year.ToString
        x = sglMargemEsquerda + (sglMargemDireita - sglMargemEsquerda) / 2
        y = 200.0
        g.DrawString(strTítulo, fntTítulo, Brushes.Black, x, y, sfCentro)
    End Sub
    ''' <summary>
    ''' Divide o texto em palavras
    ''' Testa se o comprimento da palavra cabe na folha (na horizontal) se sim desenha a seguir, se não desenha na linha a baixo
    ''' </summary>
    ''' <param name="g">O ambiente gráfico onde vamos desenhar</param>
    ''' <param name="X">Cota X</param>
    ''' <param name="Y">Cota Y</param>
    ''' <param name="Texto">A string que vamos desenhar</param>
    ''' <param name="Fonte">O tipo de letra</param>
    ''' <param name="MargemEsquerda"></param>
    ''' <param name="MargemDireita"></param>
    ''' <remarks></remarks>
    Private Sub subDesenhaString(ByVal g As Graphics, ByRef X As Single, ByRef Y As Single, ByVal Texto As String, ByVal Fonte As Font, ByVal MargemEsquerda As Single, ByVal MargemDireita As Single)
        Try
            Dim Palavras() As String = Texto.Split(" ")
            For Each s As String In Palavras
                Dim tamanho As SizeF = g.MeasureString(s, Fonte)
                If X + tamanho.Width > MargemDireita Then
                    X = MargemEsquerda
                    Y += tamanho.Height
                End If
                g.DrawString(s, Fonte, Brushes.Black, X, Y, New StringFormat)
                X += tamanho.Width
            Next
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub

    ''' <summary>
    ''' Desenha uma linha da tabela IRS
    ''' </summary>
    ''' <param name="g"></param>
    ''' <param name="Mês"></param>
    ''' <param name="TaxaIRS"></param>
    ''' <param name="SujeitoDescontos"></param>
    ''' <param name="DescontosIRS"></param>
    ''' <remarks></remarks>
    Private Sub subPrintLinhaIRS(ByVal g As Graphics, ByVal Mês As String, ByVal TaxaIRS As Single, ByVal SujeitoDescontos As Single, ByVal DescontosIRS As Single)
        x = sglColunaMês
        g.DrawString(Mês, fntTexto, Brushes.Black, x, y, New StringFormat)
        x = sglColunaTaxa
        g.DrawString(TaxaIRS.ToString("#,##0.0 %"), fntTexto, Brushes.Black, x, y, sfDireita)
        x = sglColunaX
        g.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
        x = sglColunaSujeitoImposto
        g.DrawString(SujeitoDescontos.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
        x = sglColunaDescontosIRS
        g.DrawString(DescontosIRS.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha o rodapé da tabela IRS
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintRodapéIRS(ByVal g As Graphics, ByVal TotalRetençãoIRS As Single)
        y += 2
        g.DrawLine(Pens.Black, sglColunaTaxa, y, sglColunaDescontosIRS, y)
        y += 2
        x = sglColunaTaxa
        g.DrawString("Total Descontos IRS:", fntDados, Brushes.Black, x, y, New StringFormat)
        x = sglColunaDescontosIRS
        g.DrawString(TotalRetençãoIRS.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha o rodapé da folha
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintRodapéFolha(ByVal g As Graphics)
        y += 50
        g.DrawLine(penCinza3, sglMargemEsquerda, y, sglMargemDireita, y)
    End Sub


    ''' <summary>
    ''' Carrega os valores dos funcionários relativos ao Ano seleccionado no calendário.
    ''' </summary>
    ''' <param name="Mês">Carrega mês ou subsídio dependendo do tipo de valor deste parametro</param>
    ''' <remarks></remarks>
    Private Sub subCarregaValoresAno(ByVal Mês As String)
        Try
            dgvFuncionários.Rows.Clear()
            ' Selecciona todos os funcionários que no Mês e Ano seleccionado eram funcionário (já tinham sido admitidos e não tinham rescindido)
            Dim strSelectSQL As String = "SELECT DISTINCT Funcionários.NúmeroFuncionário, Funcionários.Nome FROM Funcionários, TotalMês WHERE "
            strSelectSQL += "Funcionários.NúmeroFuncionário = TotalMês.NúmeroFuncionário AND "
            strSelectSQL += "TotalMês.Ano='" & calMês.ActiveMonth.Year.ToString() & "' "
            strSelectSQL += "ORDER BY Funcionários.Nome ASC "

            Dim sqlConnSelect As New SqlConnection(Settings.strSQLConnection)
            Dim commandSelect As New SqlCommand(strSelectSQL, sqlConnSelect)
            sqlConnSelect.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerFuncionário As SqlDataReader = commandSelect.ExecuteReader()
            ' Caso existam rows (linhas)
            If readerFuncionário.HasRows Then
                While readerFuncionário.Read()
                    Dim strNúmeroFuncionário As String = readerFuncionário.Item("NúmeroFuncionário").ToString.Trim
                    Dim strNome As String = readerFuncionário.Item("Nome").ToString.Trim
                    dgvFuncionários.Rows.Add(strNúmeroFuncionário, strNome, True)
                End While
            End If
            ' Fecha a ligação e limpa as variáveis
            sqlConnSelect.Close()
            sqlConnSelect = Nothing
            commandSelect = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Carrega os valores dos funcionários relativos ao mês ou subsídio seleccionado no calendário.
    ''' </summary>
    ''' <param name="NomeFuncionário">Carrega mês ou subsídio dependendo do tipo de valor deste parametro</param>
    ''' <remarks></remarks>
    Private Sub subCarregaValoresMês(ByVal NomeFuncionário As String)
        sglTotalDescontoIRS = 0.0
        Try
            dgvDados.Rows.Clear()
            dgvDados.Rows.Add(14) ' Criamos 14 linhas (12 meses mais 2 subsídios) para depois preencher

            ' Selecciona todos os funcionários que no Mês e Ano seleccionado eram funcionário (já tinham sido admitidos e não tinham rescindido)
            Dim strSelectSQL As String = "SELECT * FROM Funcionários, TotalMês WHERE "
            strSelectSQL += "Funcionários.NúmeroFuncionário = TotalMês.NúmeroFuncionário AND "
            strSelectSQL += "Funcionários.Nome = '" & NomeFuncionário & "' AND "
            strSelectSQL += "TotalMês.Ano='" & calMês.ActiveMonth.Year.ToString() & "' "
            strSelectSQL += "ORDER BY Funcionários.Nome ASC "

            Dim sqlConnSelect As New SqlConnection(Settings.strSQLConnection)
            Dim commandSelect As New SqlCommand(strSelectSQL, sqlConnSelect)
            sqlConnSelect.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerFuncionário As SqlDataReader = commandSelect.ExecuteReader()
            ' Caso existam rows (linhas)
            If readerFuncionário.HasRows Then
                While readerFuncionário.Read()
                    Dim strNúmeroFuncionário As String = readerFuncionário.Item("NúmeroFuncionário").ToString.Trim
                    Dim strNome As String = readerFuncionário.Item("Nome").ToString.Trim
                    Dim intMês As Integer = Int(readerFuncionário.Item("Mês").ToString.Trim)
                    Dim strFunção As String = readerFuncionário.Item("Função").ToString.Trim
                    Dim strNúmeroSegSocial As String = readerFuncionário.Item("NúmeroSegSocial").ToString.Trim
                    Dim strNIF As String = readerFuncionário.Item("NIF").ToString.Trim
                    Dim sglSujeitoDescontos As Single = Convert.ToSingle(readerFuncionário.Item("SujeitoDescontos").ToString.Trim)
                    Dim sglTaxaIRS As Single = Convert.ToSingle(readerFuncionário.Item("TaxaIRS").ToString.Trim)
                    Dim sglDescontoIRS As Single = Convert.ToSingle(readerFuncionário.Item("DescontoIRS").ToString.Trim)
                    sglTotalDescontoIRS += sglDescontoIRS
                    dgvDados.Rows(0).Cells(colDadosNomeFuncionário.Index).Value = strNome

                    dgvDados.Rows(intMês - 1).Cells(colDadosNúmeroFuncionário.Index).Value = strNúmeroFuncionário
                    dgvDados.Rows(intMês - 1).Cells(colDadosAno.Index).Value = calMês.ActiveMonth.Year
                    dgvDados.Rows(intMês - 1).Cells(colDadosMês.Index).Value = intMês
                    dgvDados.Rows(intMês - 1).Cells(colDadosNomeFuncionário.Index).Value = strNome
                    dgvDados.Rows(intMês - 1).Cells(colDadosFunção.Index).Value = strFunção
                    dgvDados.Rows(intMês - 1).Cells(colDadosNúmeroSegSocial.Index).Value = strNúmeroSegSocial
                    dgvDados.Rows(intMês - 1).Cells(colDadosNIF.Index).Value = strNIF
                    dgvDados.Rows(intMês - 1).Cells(colDadosSujeitoDescontos.Index).Value = sglSujeitoDescontos
                    dgvDados.Rows(intMês - 1).Cells(colDadosTaxaIRS.Index).Value = sglTaxaIRS
                    dgvDados.Rows(intMês - 1).Cells(colDadosDescontoIRS.Index).Value = sglDescontoIRS

                End While
            End If
            ' Fecha a ligação e limpa as variáveis
            sqlConnSelect.Close()
            sqlConnSelect = Nothing
            commandSelect = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub

    ''' <summary>
    ''' Formata o calendário mediante se é Sábado, Domingo ou Feriado
    ''' E calcula o nº total de dias do mês e nº total de dias úteis do mês
    ''' </summary>
    ''' <param name="Ano"></param>
    ''' <param name="Mês"></param>
    ''' <remarks></remarks>
    Private Sub subFormataCalendário(ByVal Ano As Integer, ByVal Mês As Integer)
        Try
            intDiasTotaisMês = 30 ' Para efeitos de segurança social, o mês tem sempre 30 diasSystem.DateTime.DaysInMonth(Ano, Mês)
            calMês.ResetDateInfo() ' Limpa as datas formatadas
            Dim dtData As DateTime = New DateTime(Ano, Mês, 1)
            Dim diaDatas As Pabo.Calendar.DateItem() = New Pabo.Calendar.DateItem(System.DateTime.DaysInMonth(Ano, Mês)) {}
            diaDatas.Initialize()
            For i As Integer = 1 To System.DateTime.DaysInMonth(Ano, Mês)
                diaDatas(i) = New Pabo.Calendar.DateItem()
                If funDiaFeriado(dtData) = "" Then
                    ' Não é Feriado
                    If dtData.DayOfWeek = DayOfWeek.Saturday Then
                        ' É sábado
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.LightBlue
                    ElseIf dtData.DayOfWeek = DayOfWeek.Sunday Then
                        ' É Domingo
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.OrangeRed
                    Else
                        ' Não é feriado e é dia útil
                        intDiasÚteis += 1
                    End If
                Else
                    ' É feriado
                    diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                    diaDatas(i).BackColor1 = Color.Orange
                End If
                dtData = dtData.AddDays(1) ' Passa para o próximo dia
            Next
            calMês.AddDateInfo(diaDatas)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
End Class