﻿Imports System.Math
Imports System.Drawing.Printing ' De acordo com toturial de: http://www.macoratti.net/08/04/vbn8_imp.htm
''' <summary>
''' Form para previsualizar os dados relativos retenção de impostos.
''' e posterior impressão dos mesmos
''' </summary>
''' <remarks></remarks>
Public Class frmDeclaraçãoRetençãoImpostos
    ' Variaveis Globais
    Dim intDiasTotaisMês As Integer
    Dim intDiasÚteis As Integer
    Dim strMês As String ' Mês actual ou "Férias" ou "Natal"
    Dim intRowActual As Integer = 0
    Dim strTipoImpressão As String
    Dim bolFimLoad As Boolean = False ' Indica que já acabou de fazer load, pelo que o programa (ou consultas) já pode aceder a todos os objectos da form

    'Variaveis das linhas
    Dim sglLinhasPorPágina As Single = 0
    Dim sglPosiçãoDaLinha As Single = 0
    Dim intLinhaActual As Integer = 0

    'Variaveis das margens
    Dim sglMargemEsquerda As Single
    Dim sglMargemSuperior As Single
    Dim sglMargemDireita As Single
    Dim sglMargemInferior As Single

    ' Variaveis das canetas
    Dim penCinza3 As Pen = New Pen(Color.Gray, 3)
    Dim penPreta2 As Pen = New Pen(Color.Black, 2)

    'Variaveis das fontes
    Dim fntNomeEmpresa As Font = New Font("Arial", 20, FontStyle.Bold)
    Dim fntMoradaEmpresa As Font = New Font("Arial", 14)
    Dim fntTítulo As Font = New Font("Arial", 14, FontStyle.Bold Or FontStyle.Underline)
    Dim fntDados As Font = New Font("Arial", 10, FontStyle.Bold) 'Or FontStyle.Underline)
    Dim fntTexto As Font = New Font("Arial", 10)
    Dim fntOutros As Font = New Font("Arial", 8)

    ' Alinhamento à direita
    Dim sfDireita As New Drawing.StringFormat
    Dim sfCentro As New Drawing.StringFormat

    ' Cotas
    Dim x As Single = 0.0
    Dim y As Single = 0.0
    Dim sglColunaNome As Single
    Dim sglColunaNúmero As Single
    Dim sglColunaSujeitoImposto As Single
    Dim sglColunaX As Single
    Dim sglColunaTaxa As Single
    Dim sglColunaValorRetenção As Single
    Dim sglEspaçoLinha As Single


    ''' <summary>
    ''' Rotina executada quando carrega a Form.
    ''' Selecciona o dia actual e formata no calendário 
    ''' A seguir carrega os valores relativos ao mês actual para a tabela e calculas os totais do mês
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frmRetençãoImpostos_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            strMês = Today.Month.ToString
            calMês.SelectDate(Today)
            subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
            subCarregaValoresMês(Today.Month.ToString)
            subCalculaTotais()
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            chkContabilidade.Checked = True
            chkArquivo.Checked = True
            btnMêsCorrente.Enabled = False
            btnMêsCorrente.BackColor = Color.Aqua
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
            bolFimLoad = True
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador alterou o mês do calendário
    ''' Carregamos os dados para o novo mês e recalculamos os totais
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub calMês_MonthChanged(ByVal sender As System.Object, ByVal e As Pabo.Calendar.MonthChangedEventArgs) Handles calMês.MonthChanged
        Try
            If bolFimLoad Then
                strMês = calMês.ActiveMonth.Month.ToString
                subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
                subCarregaValoresMês(calMês.ActiveMonth.Month.ToString)
                subCalculaTotais()
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao mês corrente
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnMêsCorrente_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMêsCorrente.Click
        Try
            strMês = calMês.ActiveMonth.Month.ToString
            calMês.SelectDate(Today)
            subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
            subCarregaValoresMês(Today.Month.ToString)
            subCalculaTotais()
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            btnMêsCorrente.Enabled = False
            btnMêsCorrente.BackColor = Color.Aqua
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao Subsídio de Férias
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSubsídioFérias_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubsídioFérias.Click
        Try
            subCarregaValoresMês("Férias")
            subCalculaTotais()
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            strMês = "Férias"
            btnMêsCorrente.Enabled = True
            btnMêsCorrente.BackColor = Color.WhiteSmoke
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = False
            btnSubsídioFérias.BackColor = Color.Aqua
            calMês.Visible = Not btnMêsCorrente.Enabled
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao Subsídio de Natal
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSubsídioNatal_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubsídioNatal.Click
        Try
            subCarregaValoresMês("Natal")
            subCalculaTotais()

        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            strMês = "Natal"
            btnMêsCorrente.Enabled = True
            btnMêsCorrente.BackColor = Color.WhiteSmoke
            btnSubsídioNatal.Enabled = False
            btnSubsídioNatal.BackColor = Color.Aqua
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
        End Try
    End Sub

    ''' <summary>
    ''' Vamos imprimir os recibos directo para a impressora
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnImprimir_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnImprimir.Click
        intRowActual = 0
        If (intRowActual + 1 < dgvDadosIRS.Rows.Count - 1) Then
            If chkContabilidade.Checked Then
                strTipoImpressão = "Contabilidade"
            ElseIf chkArquivo.Checked Then
                strTipoImpressão = "Arquivo"
            Else
                MsgBox("Tem que ter activa pelo menos um tipo de cópia: Contabilidade ou Arquivo")
                Exit Sub
            End If
            subImprimir()
        End If
    End Sub
    ''' <summary>
    ''' Cria a ordem de impressão
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subImprimir()
        'define os objetos printdocument e os eventos associados
        Dim pdReciboVencimento As Printing.PrintDocument = New Printing.PrintDocument()

        'IMPORTANTE - definimos 3 eventos para tratar a impressão : PringPage, BeginPrint e EndPrint.
        AddHandler pdReciboVencimento.PrintPage, New Printing.PrintPageEventHandler(AddressOf Me.pdRelatorios_PrintPage)
        AddHandler pdReciboVencimento.BeginPrint, New Printing.PrintEventHandler(AddressOf Me.Begin_Print)
        AddHandler pdReciboVencimento.EndPrint, New Printing.PrintEventHandler(AddressOf Me.End_Print)

        'define o objeto para visualizar a impressao
        Dim objPrintPreview As New PrintPreviewDialog

        intRowActual = 0

        Try
            'define o formulário como maximizado e com Zoom
            With objPrintPreview
                .Document = pdReciboVencimento
                .WindowState = FormWindowState.Maximized
                .PrintPreviewControl.Zoom = 1
                If strMês = "Férias" Then
                    .Text = "Subsídio de Férias - " & calMês.ActiveMonth.Year.ToString
                ElseIf strMês = "Natal" Then
                    .Text = "Subsídio de Natal - " & calMês.ActiveMonth.Year.ToString
                Else
                    .Text = "Retenção de Impostos: " & calMês.ActiveMonth.Year.ToString & " - " & String.Format("{0:00}", Int(calMês.ActiveMonth.Month))
                End If
                .ShowDialog()
            End With
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Começa a imprimir, não temos nada a fazer nesta parte, mas fica aqui para se no futuro necessitar de abrir ligações SQL
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Begin_Print(ByVal sender As Object, ByVal e As Printing.PrintEventArgs)
    End Sub
    ''' <summary>
    ''' Construção das páginas a imprimir
    ''' Desenhamos os recibos
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub pdRelatorios_PrintPage(ByVal sender As System.Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs)
        Dim bolNovaPágina As Boolean = False
        Try
            ' Margen
            sglMargemEsquerda = e.MarginBounds.Left
            sglMargemSuperior = e.MarginBounds.Top
            sglMargemDireita = e.MarginBounds.Right
            sglMargemInferior = e.MarginBounds.Bottom

            ' Alinhamento à direita
            sfDireita.Alignment = StringAlignment.Far
            ' Alinhamento ao centro
            sfCentro.Alignment = StringAlignment.Center

            ' Cotas para as tabela
            sglColunaNome = sglMargemEsquerda + 0.0
            sglColunaNúmero = sglColunaNome + 300.0
            sglColunaSujeitoImposto = sglColunaNúmero + 170.0
            sglColunaX = sglColunaSujeitoImposto + 5.0
            sglColunaTaxa = sglColunaX + 65.0
            sglColunaValorRetenção = sglMargemDireita
            sglEspaçoLinha = 19.0

            subPrintCabeçalhoFolha(e.Graphics)
            subPrintCabeçalhoRelatório(e.Graphics)

            ' Retensão IRS
            subPrintCabeçalhoRelatórioIRS(e.Graphics)
            subPrintCabeçalhoTabelaIRS(e.Graphics)
            y += sglEspaçoLinha

            Dim sglTotalRetençãoIRS As Single = 0.0

            For Each row As DataGridViewRow In dgvDadosIRS.Rows
                If row.Index >= intRowActual AndAlso Not row.IsNewRow Then ' Só imprime da linha actual em diante
                    Dim strNome As String = dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSNomeFuncionário.Index).Value
                    Dim strNIF As String = dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSNIF.Index).Value
                    Dim sglSujeitoDescontos As Single = Convert.ToSingle(dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSSujeitoDescontos.Index).Value)
                    Dim sglTaxaIRS As Single = Convert.ToSingle(dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSTaxaIRS.Index).Value)
                    Dim sglDescontosIRS As Single = Convert.ToSingle(dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSDescontoIRS.Index).Value)

                    subPrintLinhaIRS(e.Graphics, strNome, strNIF, sglSujeitoDescontos, sglTaxaIRS, sglDescontosIRS)

                    sglTotalRetençãoIRS += sglDescontosIRS
                    y += sglEspaçoLinha
                    intRowActual += 1 ' Contabiliza o nº da linha actual

                    If y > sglMargemInferior - 100 Then ' Já não cabe mais linhas na página
                        bolNovaPágina = True
                        Exit For
                    End If
                End If
            Next
            If Not bolNovaPágina Then subPrintRodapéIRS(e.Graphics, sglTotalRetençãoIRS)

            ' Retenção IRP
            Dim sglTotalRetençãoIRP As Single = 0.0
            If strMês <> "Férias" AndAlso strMês <> "Natal" Then
                subPrintCabeçalhoRelatórioIRP(e.Graphics)
                subPrintCabeçalhoTabelaIRP(e.Graphics)
                y += sglEspaçoLinha

                intRowActual = 0
                For Each row As DataGridViewRow In dgvDadosIRP.Rows
                    If row.Index >= intRowActual AndAlso Not row.IsNewRow Then ' Só imprime da linha actual em diante
                        Dim strDesignação As String = dgvDadosIRP.Rows(row.Index).Cells(colDadosIRPDesignação.Index).Value
                        Dim sglRenda As Single = Convert.ToSingle(dgvDadosIRP.Rows(row.Index).Cells(colDadosIRPRenda.Index).Value)
                        Dim sglTaxaIRP As Single = Convert.ToSingle(dgvDadosIRP.Rows(row.Index).Cells(colDadosIRPTaxaIRP.Index).Value)
                        Dim sglValorIRP As Single = Convert.ToSingle(dgvDadosIRP.Rows(row.Index).Cells(colDadosIRPValorIRP.Index).Value)

                        subPrintLinhaIRP(e.Graphics, strDesignação, sglRenda, sglTaxaIRP, sglValorIRP)

                        sglTotalRetençãoIRP += sglValorIRP
                        y += sglEspaçoLinha
                        intRowActual += 1 ' Contabiliza o nº da linha actual

                        If y > sglMargemInferior - 100 Then ' Já não cabe mais linhas na página
                            bolNovaPágina = True
                            Exit For
                        End If
                    End If
                Next
                If Not bolNovaPágina Then subPrintRodapéIRP(e.Graphics, sglTotalRetençãoIRP)
            End If

            If Not bolNovaPágina Then subPrintRodapéRelatório(e.Graphics, sglTotalRetençãoIRS + sglTotalRetençãoIRP)
            subPrintRodapéFolha(e.Graphics)

        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            If bolNovaPágina Then ' Há mais páginas para imprimir
                e.HasMorePages = True
            Else
                If strTipoImpressão = "Contabilidade" Then
                    If chkArquivo.Checked Then
                        strTipoImpressão = "Arquivo"
                        intRowActual = 0
                        e.HasMorePages = True
                    Else
                        e.HasMorePages = False
                    End If
                Else
                    e.HasMorePages = False
                End If
            End If
        End Try
    End Sub
    ''' <summary>
    ''' Fim de impressão, neste caso é só fim não temos que fazer nada
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="byvale"></param>
    ''' <remarks></remarks>
    Private Sub End_Print(ByVal sender As Object, ByVal byvale As Printing.PrintEventArgs)

    End Sub
    ''' <summary>
    ''' Desenha o cabeçalho da folha
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoFolha(ByVal g As Graphics)
        'Linhas 
        g.DrawLine(penCinza3, sglColunaNome, 60, sglColunaValorRetenção, 60)
        g.DrawLine(penCinza3, sglColunaNome, 170, sglColunaValorRetenção, 170)

        ' Variaveis da Empresa
        Dim strNomeEmpresa As String = Settings.strNomeEmpresa
        Dim strMorada As String = Settings.strMoradaEmpresa
        Dim strCódigoPostal As String = Settings.strCódigoPostalEmpresa
        Dim strLocalidade As String = Settings.strLocalidadeEmpresa

        Dim szfNomeEmpresa As SizeF = g.MeasureString(strNomeEmpresa, fntNomeEmpresa)
        Dim szfMorada As SizeF = g.MeasureString(strMorada, fntMoradaEmpresa)
        Dim szfCódigoPostal As SizeF = g.MeasureString(strCódigoPostal, fntMoradaEmpresa)
        Dim szfLocalidade As SizeF = g.MeasureString(strLocalidade, fntMoradaEmpresa)

        g.DrawString(strNomeEmpresa, fntNomeEmpresa, Brushes.Black, sglMargemEsquerda, 75, New StringFormat())
        g.DrawString(strMorada, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda, 75 + szfNomeEmpresa.Height, New StringFormat())
        g.DrawString(strCódigoPostal, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda, 75 + szfNomeEmpresa.Height + szfMorada.Height, New StringFormat())
        g.DrawString(strLocalidade, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda + szfCódigoPostal.Width, 75 + szfNomeEmpresa.Height + szfMorada.Height, New StringFormat())

        y = 150
        x = sglMargemDireita
        g.DrawString(strTipoImpressão, fntOutros, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha o cabeçalho do relatório
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoRelatório(ByVal g As Graphics)
        ' Desenha o Título Centrado
        Dim strData As String
        If strMês = "Férias" Then
            strData = "Subsídio de Férias"
        ElseIf strMês = "Natal" Then
            strData = "Subsídio de Natal"
        Else
            strData = String.Format("{0:00}", Int(calMês.ActiveMonth.Month)) & "-" & calMês.ActiveMonth.Year.ToString
        End If
        Dim strTítulo As String = "Retenção de Impostos: " & strData
        x = sglMargemEsquerda + (sglMargemDireita - sglMargemEsquerda) / 2
        y += 50.0
        g.DrawString(strTítulo, fntTítulo, Brushes.Black, x, y, sfCentro)
    End Sub

    ''' <summary>
    ''' Desenha o cabeçalho do relatório
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoRelatórioIRS(ByVal g As Graphics)
        Dim strTítulo As String = "Retenção de IRS "
        x = sglMargemEsquerda + (sglMargemDireita - sglMargemEsquerda) / 2
        y += 50.0
        g.DrawString(strTítulo, fntMoradaEmpresa, Brushes.Black, x, y, sfCentro)
    End Sub
    ''' <summary>
    ''' Desenha o cabeçalho da tabela IRS
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoTabelaIRS(ByVal g As Graphics)
        y += 25.0
        x = sglColunaNome
        g.DrawString("Nome", fntDados, Brushes.Black, x, y, New StringFormat)
        x = sglColunaNúmero
        g.DrawString("NIF", fntDados, Brushes.Black, x, y, New StringFormat)
        x = sglColunaSujeitoImposto
        g.DrawString("Sujeito IRS", fntDados, Brushes.Black, x, y, sfDireita)
        x = sglColunaTaxa
        g.DrawString("IRS", fntDados, Brushes.Black, x, y, sfDireita)
        x = sglColunaValorRetenção
        g.DrawString("Valor IRS", fntDados, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha uma linha da tabela IRS
    ''' </summary>
    ''' <param name="g"></param>
    ''' <param name="Nome"></param>
    ''' <param name="NIF"></param>
    ''' <param name="SujeitoDescontos"></param>
    ''' <param name="TaxaIRS"></param>
    ''' <param name="DescontosIRS"></param>
    ''' <remarks></remarks>
    Private Sub subPrintLinhaIRS(ByVal g As Graphics, ByVal Nome As String, ByVal NIF As String, ByVal SujeitoDescontos As Single, ByVal TaxaIRS As Single, ByVal DescontosIRS As Single)
        x = sglColunaNome
        g.DrawString(Nome, fntTexto, Brushes.Black, x, y, New StringFormat)
        x = sglColunaNúmero
        g.DrawString(String.Format("{0:000 000 000}", Convert.ToUInt64(NIF)), fntTexto, Brushes.Black, x, y, New StringFormat)
        x = sglColunaSujeitoImposto
        g.DrawString(SujeitoDescontos.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
        x = sglColunaX
        g.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
        x = sglColunaTaxa
        g.DrawString(TaxaIRS.ToString("#,##0.0 %"), fntTexto, Brushes.Black, x, y, sfDireita)
        x = sglColunaValorRetenção
        g.DrawString(DescontosIRS.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha o rodapé da tabela IRS
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintRodapéIRS(ByVal g As Graphics, ByVal TotalRetençãoIRS As Single)
        y += 2
        g.DrawLine(Pens.Black, sglColunaSujeitoImposto, y, sglColunaValorRetenção, y)
        y += 2
        x = sglColunaSujeitoImposto
        g.DrawString("Total IRS:", fntDados, Brushes.Black, x, y, New StringFormat)
        x = sglColunaValorRetenção
        g.DrawString(TotalRetençãoIRS.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
    End Sub

    ''' <summary>
    ''' Desenha o cabeçalho do relatório
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoRelatórioIRP(ByVal g As Graphics)
        Dim strTítulo As String = "Retenção de IRP"
        x = sglMargemEsquerda + (sglMargemDireita - sglMargemEsquerda) / 2
        y += 50.0
        g.DrawString(strTítulo, fntMoradaEmpresa, Brushes.Black, x, y, sfCentro)
    End Sub
    ''' <summary>
    ''' Desenha o cabeçalho da tabela IRP
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintCabeçalhoTabelaIRP(ByVal g As Graphics)
        y += 25.0
        x = sglColunaNúmero - 100
        g.DrawString("Designação", fntDados, Brushes.Black, x, y, New StringFormat)
        x = sglColunaSujeitoImposto
        g.DrawString("Renda", fntDados, Brushes.Black, x, y, sfDireita)
        x = sglColunaTaxa
        g.DrawString("IRP", fntDados, Brushes.Black, x, y, sfDireita)
        x = sglColunaValorRetenção
        g.DrawString("Valor IRP", fntDados, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha uma linha da tabela IRP
    ''' </summary>
    ''' <param name="g"></param>
    ''' <param name="Nome"></param>
    ''' <param name="NIF"></param>
    ''' <param name="SujeitoDescontos"></param>
    ''' <param name="TaxaIRS"></param>
    ''' <param name="DescontosIRS"></param>
    ''' <remarks></remarks>
    Private Sub subPrintLinhaIRP(ByVal g As Graphics, ByVal Designação As String, ByVal Renda As Single, ByVal TaxaIRP As Single, ByVal ValorIRP As Single)
        x = sglColunaNúmero - 100
        g.DrawString(Designação, fntTexto, Brushes.Black, x, y, New StringFormat)
        x = sglColunaSujeitoImposto
        g.DrawString(Renda.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
        x = sglColunaX
        g.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
        x = sglColunaTaxa
        g.DrawString(TaxaIRP.ToString("#,##0.0 %"), fntTexto, Brushes.Black, x, y, sfDireita)
        x = sglColunaValorRetenção
        g.DrawString(ValorIRP.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
    End Sub
    ''' <summary>
    ''' Desenha o rodapé da tabela IRP
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintRodapéIRP(ByVal g As Graphics, ByVal TotalRetençãoIRP As Single)
        y += 2
        g.DrawLine(Pens.Black, sglColunaSujeitoImposto, y, sglColunaValorRetenção, y)
        y += 2
        x = sglColunaSujeitoImposto
        g.DrawString("Total IRP:", fntDados, Brushes.Black, x, y, New StringFormat)
        x = sglColunaValorRetenção
        g.DrawString(TotalRetençãoIRP.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
    End Sub

    Private Sub subPrintRodapéRelatório(ByVal g As Graphics, ByVal TotalRetenção As Single)
        y += 80
        x = 180
        g.DrawString("Total Retenção Impostos:", fntDados, Brushes.Black, x, y, New StringFormat)
        x = 160 + 470
        g.DrawString(TotalRetenção.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
        g.DrawRectangle(penPreta2, 160, y - 10, 490, sglEspaçoLinha * 2)
    End Sub
    ''' <summary>
    ''' Desenha o rodapé da folha
    ''' </summary>
    ''' <param name="g"></param>
    ''' <remarks></remarks>
    Private Sub subPrintRodapéFolha(ByVal g As Graphics)
        y += 50
        g.DrawLine(penCinza3, sglMargemEsquerda, y, sglMargemDireita, y)
        ' TODO -> Meter o nº da página
    End Sub

    Private Sub subCarregaValoresMês(ByVal Mês As String)
        subCarregaValoresIRS(Mês)
        If Mês <> "Férias" AndAlso Mês <> "Natal" Then
            subCarregaValoresIRP(Mês)
        Else
            dgvDadosIRP.Rows.Clear()
        End If
    End Sub
    Private Sub subCarregaValoresIRS(ByVal Mês As String)
        Try
            dgvDadosIRS.Rows.Clear()
            ' Selecciona todos os funcionários que no Mês e Ano seleccionado eram funcionário (já tinham sido admitidos e não tinham rescindido)
            Dim strSelectSQL As String = "SELECT * FROM Funcionários, Mês WHERE "
            strSelectSQL += "Funcionários.NúmeroFuncionário = Mês.NúmeroFuncionário AND "
            strSelectSQL += "Mês.Ano='" & calMês.ActiveMonth.Year.ToString() & "' AND "
            If Mês = "Férias" Then
                strSelectSQL += "Mês.Mês='14' " ' 14º Mês
            ElseIf Mês = "Natal" Then
                strSelectSQL += "Mês.Mês='13' " ' 13º Mês
            Else
                strSelectSQL += "Mês.Mês='" & calMês.ActiveMonth.Month.ToString("00") & "' "
            End If
            strSelectSQL += "ORDER BY Funcionários.Nome ASC "

            Dim sqlConnSelect As New SqlConnection(Settings.strSQLConnection)
            Dim commandSelect As New SqlCommand(strSelectSQL, sqlConnSelect)
            sqlConnSelect.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerFuncionário As SqlDataReader = commandSelect.ExecuteReader()
            ' Caso existam rows (linhas)
            If readerFuncionário.HasRows Then
                While readerFuncionário.Read()
                    Dim strNúmeroFuncionário As String = readerFuncionário.Item("NúmeroFuncionário").ToString.Trim
                    Dim intAno As Integer = Int(readerFuncionário.Item("Ano"))
                    Dim intMês As Integer
                    If Mês = "Férias" Then
                        intMês = 14 ' 14º Mês
                    ElseIf Mês = "Natal" Then
                        intMês = 13 ' 13º Mês
                    Else
                        intMês = Int(readerFuncionário.Item("Mês"))
                    End If
                    Dim strNome As String = readerFuncionário.Item("Nome").ToString.Trim
                    Dim strNúmeroSegSocial As String = readerFuncionário.Item("NúmeroSegSocial").ToString.Trim
                    Dim strNIF As String = readerFuncionário.Item("NIF").ToString.Trim
                    Dim intDiasMês As Integer = Int(readerFuncionário.Item("DiasMês"))
                    Dim intDiasBaixa As Integer
                    Dim intDiasFérias As Integer
                    Dim intDiasFaltas As Integer
                    If Mês = "Férias" Or Mês = " Natal" Then
                        intDiasBaixa = 0
                        intDiasFérias = 0
                        intDiasFaltas = 0
                    Else
                        intDiasBaixa = Int(readerFuncionário.Item("DiasBaixa"))
                        intDiasFérias = Int(readerFuncionário.Item("DiasFérias"))
                        intDiasFaltas = Int(readerFuncionário.Item("DiasFaltas"))
                    End If
                    Dim sglRemuneraçãoDiária As Single = Round(Convert.ToDecimal(readerFuncionário.Item("VencimentoBase").ToString.Trim) / intDiasMês)
                    Dim sglRemuneraçãoBase As Single = Convert.ToDecimal(readerFuncionário.Item("VencimentoBase").ToString.Trim)
                    Dim intDiasSubRefeição As Integer
                    Dim sglSubRefeiçãoDias As Single
                    Dim sglSubRefeiçãoTotal As Single
                    Dim sglHorasExtras As Single = 0.0

                    If Mês = "Férias" Or Mês = " Natal" Then
                        intDiasSubRefeição = 0
                        sglSubRefeiçãoDias = 0.0
                        sglSubRefeiçãoTotal = 0.0
                    Else
                        intDiasSubRefeição = Int(readerFuncionário.Item("DiasSubRefeição"))
                        sglSubRefeiçãoDias = Convert.ToSingle(readerFuncionário.Item("SubRefeição"))
                        sglSubRefeiçãoTotal = intDiasSubRefeição * sglSubRefeiçãoDias
                    End If

                    ' ---------------------------------------
                    ' Cálculo das horas extras do funcionário
                    Dim strHorasExtrasSQL As String = "SELECT * FROM  HorasExtras WHERE "
                    strHorasExtrasSQL += "NúmeroFuncionário ='" & strNúmeroFuncionário.ToString & "' AND "
                    strHorasExtrasSQL += "Ano='" & calMês.ActiveMonth.Year.ToString() & "' AND "
                    strHorasExtrasSQL += "Mês='" & calMês.ActiveMonth.Month.ToString("00") & "' "

                    Dim sqlConnHorasExtras As New SqlConnection(Settings.strSQLConnection)
                    Dim commandHorasExtras As New SqlCommand(strHorasExtrasSQL, sqlConnHorasExtras)
                    sqlConnHorasExtras.Open()

                    Dim readerHorasExtras As SqlDataReader = commandHorasExtras.ExecuteReader()
                    ' Caso existam rows (linhas)
                    If readerHorasExtras.HasRows Then
                        While readerHorasExtras.Read()
                            Dim sglNúmeroHorasExtras As Single = Convert.ToSingle(readerHorasExtras.Item("NúmeroHoras"))
                            Dim sglValorHoraNormal As Single = Convert.ToSingle(readerHorasExtras.Item("ValorHoraNormal"))
                            Dim sglPercentagem As Single = Convert.ToSingle(readerHorasExtras.Item("Percentagem"))
                            sglHorasExtras += sglNúmeroHorasExtras * sglValorHoraNormal * (sglPercentagem + 1.0)
                        End While
                    End If
                    sqlConnHorasExtras.Close()
                    sqlConnHorasExtras = Nothing
                    commandHorasExtras = Nothing
                    ' ---------------------------------------
                    ' Continuamos com a consulta anterior

                    Dim sglReduçãoVencimentoFaltas As Single = intDiasFaltas * Settings.intNúmeroHorasDiárias * modCálculos.funVencimentoHora(Convert.ToDecimal(readerFuncionário.Item("VencimentoBase").ToString.Trim), Settings.intNúmeroHorasSemanais)
                    Dim sglTotalIlíquido As Single = sglRemuneraçãoBase + sglHorasExtras + sglSubRefeiçãoTotal - sglReduçãoVencimentoFaltas
                    If sglTotalIlíquido < 0 Then sglTotalIlíquido = 0 ' De lei, o funcionário quando falta pode descontar mais doque ganharia, e teria que pagar à entidade patronal, mas a lei não permite o funcionário pagar à entidade patronal pelo que o total a receber=0
                    Dim sglSujeitoDescontos As Single = sglRemuneraçãoBase + sglHorasExtras - sglReduçãoVencimentoFaltas
                    If sglSujeitoDescontos < 0 Then sglSujeitoDescontos = 0
                    Dim sglTaxaSegSocial As Single
                    If readerFuncionário.Item("SócioEmpresa").ToString.Trim = "" Then
                        sglTaxaSegSocial = Settings.sglTaxaSegSocialFuncionárioEmpresa / 100
                    Else
                        sglTaxaSegSocial = Settings.sglTaxaSegSocialSócioEmpresa / 100
                    End If
                    Dim sglDescontosSegSocial As Single = sglTaxaSegSocial * sglSujeitoDescontos
                    Dim sglTaxaIRS As Single = Convert.ToSingle(readerFuncionário.Item("TaxaIRS"))
                    Dim sglDescontosIRS As Single = Int(sglTaxaIRS * sglSujeitoDescontos)
                    Dim sglTotalDescontos As Single = sglDescontosSegSocial + sglDescontosIRS
                    Dim sglTotalLíquido As Single = sglTotalIlíquido - sglTotalDescontos

                    dgvDadosIRS.Rows.Add(strNúmeroFuncionário, intAno, intMês, strNome, strNúmeroSegSocial, strNIF, sglSujeitoDescontos, sglTaxaSegSocial, sglTaxaIRS, sglDescontosIRS)
                End While
            End If
            ' Fecha a ligação e limpa as variáveis
            sqlConnSelect.Close()
            sqlConnSelect = Nothing
            commandSelect = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    Private Sub subCarregaValoresIRP(ByVal Mês As String)
        Try
            dgvDadosIRP.Rows.Clear()
            ' Selecciona todos os funcionários que no Mês e Ano seleccionado eram funcionário (já tinham sido admitidos e não tinham rescindido)
            Dim strSelectSQL As String = "SELECT * FROM Rendas WHERE "
            strSelectSQL += "Ano='" & calMês.ActiveMonth.Year.ToString() & "' AND "
            strSelectSQL += "Mês='" & calMês.ActiveMonth.Month.ToString("00") & "' AND "
            strSelectSQL += "Valor > 0 "
            strSelectSQL += "ORDER BY Designação ASC "

            Dim sqlConnSelect As New SqlConnection(Settings.strSQLConnection)
            Dim commandSelect As New SqlCommand(strSelectSQL, sqlConnSelect)
            sqlConnSelect.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerRenda As SqlDataReader = commandSelect.ExecuteReader()
            ' Caso existam rows (linhas)
            If readerRenda.HasRows Then
                While readerRenda.Read()
                    Dim strDesignação As String = readerRenda.Item("Designação").ToString.Trim
                    Dim sglRenda As Single = Convert.ToDecimal(readerRenda.Item("Valor").ToString.Trim)
                    Dim sglValorIRP As Single = Settings.sglTaxaIRP * sglRenda / 100
                    dgvDadosIRP.Rows.Add(strDesignação, sglRenda, Settings.sglTaxaIRP / 100, sglValorIRP)
                End While
            End If
            ' Fecha a ligação e limpa as variáveis
            sqlConnSelect.Close()
            sqlConnSelect = Nothing
            commandSelect = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Calsola os totais do Mês para:
    ''' Descontos Segurança Social
    ''' Descontos IRS
    ''' Valores Líquidos
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subCalculaTotais()
        Try
            Dim sglTotalDescontoSegSocial As Single = 0.0
            Dim sglTotalDescontoIRS As Single = 0.0
            Dim sglTotalDescontoIRP As Single = 0.0

            For Each row As DataGridViewRow In dgvDadosIRS.Rows
                If Not row.IsNewRow Then
                    If Convert.ToDecimal(dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSTaxaSegSocial.Index).Value) = Settings.sglTaxaSegSocialFuncionário Then
                        sglTotalDescontoSegSocial += Round(Convert.ToDecimal(dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSSujeitoDescontos.Index).Value) * Settings.sglTaxaSegSocialFuncionárioEmpresa / 100, 2)
                    Else
                        sglTotalDescontoSegSocial += Round(Convert.ToDecimal(dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSSujeitoDescontos.Index).Value) * Settings.sglTaxaSegSocialSócioEmpresa / 100, 2)
                    End If
                    sglTotalDescontoIRS += Int(dgvDadosIRS.Rows(row.Index).Cells(colDadosIRSDescontoIRS.Index).Value)
                End If
            Next

            For Each row As DataGridViewRow In dgvDadosIRP.Rows
                If Not row.IsNewRow Then
                    sglTotalDescontoIRP += dgvDadosIRP.Rows(row.Index).Cells(colDadosIRPValorIRP.Index).Value
                End If
            Next

            txbTotalDescontoSegSocial.Text = sglTotalDescontoSegSocial.ToString("#,##0.00 €")
            txbTotalDescontoIRS.Text = sglTotalDescontoIRS.ToString("#,##0.00 €")
            txbTotalDescontoIRP.Text = sglTotalDescontoIRP.ToString("#,##0.00 €")
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub

    ''' <summary>
    ''' Formata o calendário mediante se é Sábado, Domingo ou Feriado
    ''' E calcula o nº total de dias do mês e nº total de dias úteis do mês
    ''' </summary>
    ''' <param name="Ano"></param>
    ''' <param name="Mês"></param>
    ''' <remarks></remarks>
    Private Sub subFormataCalendário(ByVal Ano As Integer, ByVal Mês As Integer)
        Try
            intDiasTotaisMês = 30 ' Para efeitos de segurança social, o mês tem sempre 30 diasSystem.DateTime.DaysInMonth(Ano, Mês)
            calMês.ResetDateInfo() ' Limpa as datas formatadas
            Dim dtData As DateTime = New DateTime(Ano, Mês, 1)
            Dim diaDatas As Pabo.Calendar.DateItem() = New Pabo.Calendar.DateItem(System.DateTime.DaysInMonth(Ano, Mês)) {}
            diaDatas.Initialize()
            For i As Integer = 1 To System.DateTime.DaysInMonth(Ano, Mês)
                diaDatas(i) = New Pabo.Calendar.DateItem()
                If funDiaFeriado(dtData) = "" Then
                    ' Não é Feriado
                    If dtData.DayOfWeek = DayOfWeek.Saturday Then
                        ' É sábado
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.LightBlue
                    ElseIf dtData.DayOfWeek = DayOfWeek.Sunday Then
                        ' É Domingo
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.OrangeRed
                    Else
                        ' Não é feriado e é dia útil
                        intDiasÚteis += 1
                    End If
                Else
                    ' É feriado
                    diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                    diaDatas(i).BackColor1 = Color.Orange
                End If
                dtData = dtData.AddDays(1) ' Passa para o próximo dia
            Next
            calMês.AddDateInfo(diaDatas)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
End Class