﻿Imports System.Math
Imports System.Drawing.Printing ' De acordo com toturial de: http://www.macoratti.net/08/04/vbn8_imp.htm
''' <summary>
''' Form para previsualizar os dados relativos aos recibos de vencimento.
''' e posterior impressão dos mesmos
''' </summary>
''' <remarks></remarks>
Public Class frmRecibosVencimento
    Dim intDiasTotaisMês As Integer
    Dim intDiasÚteis As Integer
    Dim strMês As String ' Mês actual ou "Férias" ou "Natal"
    Dim intRowActual As Integer = 0
    Dim strTipoImpressão As String

    Dim bolFimLoad As Boolean = False ' Indica que já acabou de fazer load, pelo que o programa (ou consultas) já pode aceder a todos os objectos da form

    ''' <summary>
    ''' Rotina executada quando carrega a Form.
    ''' Selecciona o dia actual e formata no calendário 
    ''' A seguir carrega os valores relativos ao mês actual para a tabela e calculas os totais do mês
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub frmRecibosVencimento_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            strMês = Today.Month.ToString
            calMês.SelectDate(Today)
            subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
            subCarregaValoresMês(Today.Month.ToString)
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            dgvMês.ReadOnly = False
            dgvMês.Columns(colImprimir.Index).ReadOnly = False
            chkContabilidade.Checked = True
            chkFuncionário.Checked = True
            chkArquivo.Checked = True
            btnMêsCorrente.Enabled = False
            btnMêsCorrente.BackColor = Color.Aqua
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
            bolFimLoad = True
        End Try
    End Sub
    ''' <summary>
    ''' O utilizador alterou o mês do calendário
    ''' Carregamos os dados para o novo mês e recalculamos os totais
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub calMês_MonthChanged(ByVal sender As System.Object, ByVal e As Pabo.Calendar.MonthChangedEventArgs) Handles calMês.MonthChanged
        Try
            If bolFimLoad Then
                strMês = calMês.ActiveMonth.Month.ToString
                subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
                subCarregaValoresMês(calMês.ActiveMonth.Month.ToString)
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao mês corrente
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnMêsCorrente_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMêsCorrente.Click
        Try
            strMês = calMês.ActiveMonth.Month.ToString
            calMês.SelectDate(Today)
            subFormataCalendário(calMês.ActiveMonth.Year, calMês.ActiveMonth.Month)
            subCarregaValoresMês(Today.Month.ToString)
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            btnMêsCorrente.Enabled = False
            btnMêsCorrente.BackColor = Color.Aqua
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao Subsídio de Férias
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSubsídioFérias_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubsídioFérias.Click
        Try
            subCarregaValoresMês("Férias")
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            strMês = "Férias"
            btnMêsCorrente.Enabled = True
            btnMêsCorrente.BackColor = Color.WhiteSmoke
            btnSubsídioNatal.Enabled = True
            btnSubsídioNatal.BackColor = Color.WhiteSmoke
            btnSubsídioFérias.Enabled = False
            btnSubsídioFérias.BackColor = Color.Aqua
            calMês.Visible = Not btnMêsCorrente.Enabled
        End Try
    End Sub
    ''' <summary>
    ''' Valores relativos ao Subsídio de Natal
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnSubsídioNatal_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSubsídioNatal.Click
        Try
            subCarregaValoresMês("Natal")
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            strMês = "Natal"
            btnMêsCorrente.Enabled = True
            btnMêsCorrente.BackColor = Color.WhiteSmoke
            btnSubsídioNatal.Enabled = False
            btnSubsídioNatal.BackColor = Color.Aqua
            btnSubsídioFérias.Enabled = True
            btnSubsídioFérias.BackColor = Color.WhiteSmoke
            calMês.Visible = Not btnMêsCorrente.Enabled
        End Try
    End Sub

    ''' <summary>
    ''' Vamos imprimir os recibos directo para a impressora
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub btnImprimir_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnImprimir.Click
        intRowActual = 0
        If (intRowActual + 1 < dgvMês.Rows.Count - 1) Then
            If chkContabilidade.Checked Then
                strTipoImpressão = "Contabilidade"
            ElseIf chkFuncionário.Checked Then
                strTipoImpressão = "Funcionário"
            ElseIf chkArquivo.Checked Then
                strTipoImpressão = "Arquivo"
            Else
                MsgBox("Tem que ter activa pelo menos um tipo de cópia: Contabilidade, Funcionário ou Arquivo")
                Exit Sub
            End If

            Dim bolImprimir As Boolean
            For Each row As DataGridViewRow In dgvMês.Rows
                bolImprimir = bolImprimir Or dgvMês.Rows(row.Index).Cells(colImprimir.Index).Value
            Next

            If bolImprimir AndAlso (intRowActual + 1 < dgvMês.Rows.Count - 1) Then
                subImprimir()
            Else
                MsgBox("Tem que ter activo pelo menos um funcionário na tabela")
            End If
        End If
    End Sub
    ''' <summary>
    ''' Cria a ordem de impressão
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subImprimir()

        For i As Integer = 0 To dgvMês.Rows.Count - 1
            If dgvMês.Rows(i).Cells(colImprimir.Index).Value Then
                intRowActual = i
                Exit For
            End If
        Next
        'define os objetos printdocument e os eventos associados
        Dim pdReciboVencimento As Printing.PrintDocument = New Printing.PrintDocument()

        'IMPORTANTE - definimos 3 eventos para tratar a impressão : PringPage, BeginPrint e EndPrint.
        AddHandler pdReciboVencimento.PrintPage, New Printing.PrintPageEventHandler(AddressOf Me.pdRelatorios_PrintPage)
        AddHandler pdReciboVencimento.BeginPrint, New Printing.PrintEventHandler(AddressOf Me.Begin_Print)
        AddHandler pdReciboVencimento.EndPrint, New Printing.PrintEventHandler(AddressOf Me.End_Print)

        'define o objeto para visualizar a impressao
        Dim objPrintPreview As New PrintPreviewDialog

        Try
            'define o formulário como maximizado e com Zoom
            With objPrintPreview
                .Document = pdReciboVencimento
                .WindowState = FormWindowState.Maximized
                .PrintPreviewControl.Zoom = 1
                If strMês = "Férias" Then
                    .Text = "Subsídio de Férias - " & calMês.ActiveMonth.Year.ToString
                ElseIf strMês = "Natal" Then
                    .Text = "Subsídio de Natal - " & calMês.ActiveMonth.Year.ToString
                Else
                    .Text = "Recibos Vencimento: " & calMês.ActiveMonth.Year.ToString & " - " & String.Format("{0:00}", Int(calMês.ActiveMonth.Month))
                End If
                .ShowDialog()
            End With
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Começa a imprimir, não temos nada a fazer nesta parte, mas fica aqui para se no futuro necessitar de abrir ligações SQL
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub Begin_Print(ByVal sender As Object, ByVal e As Printing.PrintEventArgs)
    End Sub
    ''' <summary>
    ''' Construção das páginas a imprimir
    ''' Desenhamos os recibos
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub pdRelatorios_PrintPage(ByVal sender As System.Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs)
        Try
            If dgvMês.Rows(intRowActual).Cells(colImprimir.Index).Value Then

                subGravarTotais() ' Primeiro guardamos os valores (para usar nas declarações)

                'Variaveis das linhas
                Dim sglLinhasPorPágina As Single = 0
                Dim sglPosiçãoDaLinha As Single = 0
                Dim intLinhaActual As Integer = 0

                'Variaveis das margens
                Dim sglMargemEsquerda As Single = e.MarginBounds.Left
                Dim sglMargemSuperior As Single = e.MarginBounds.Top + 100
                Dim sglMargemDireita As Single = e.MarginBounds.Right
                Dim sglMargemInferior As Single = e.MarginBounds.Bottom
                Dim penCinza3 As Pen = New Pen(Color.Gray, 3)
                Dim penPreta2 As Pen = New Pen(Color.Black, 2)

                'Variaveis das fontes
                Dim fntNomeEmpresa As Font = New Font("Arial", 20, FontStyle.Bold)
                Dim fntMoradaEmpresa As Font = New Font("Arial", 14)
                Dim fntTítulo As Font = New Font("Arial", 14, FontStyle.Bold Or FontStyle.Underline)
                Dim fntDados As Font = New Font("Arial", 10, FontStyle.Bold) 'Or FontStyle.Underline)
                Dim fntTexto As Font = New Font("Arial", 10)
                Dim fntOutros As Font = New Font("Arial", 8)

                'define valores para linha atual e para linha da impressao
                'intLinhaActual = 0
                'Dim L As Integer = 0

                'Linhas 
                e.Graphics.DrawLine(penCinza3, sglMargemEsquerda, 60, sglMargemDireita, 60)
                e.Graphics.DrawLine(penCinza3, sglMargemEsquerda, 170, sglMargemDireita, 170)
                'e.Graphics.DrawLine(penCanetaDaImpressora, sglMargemEsquerda, 190, sglMargemDireita, 190)

                ' Variaveis da Empresa
                Dim strNomeEmpresa As String = Settings.strNomeEmpresa
                Dim strMorada As String = Settings.strMoradaEmpresa
                Dim strCódigoPostal As String = Settings.strCódigoPostalEmpresa
                Dim strLocalidade As String = Settings.strLocalidadeEmpresa

                Dim szfNomeEmpresa As SizeF = e.Graphics.MeasureString(strNomeEmpresa, fntNomeEmpresa)
                Dim szfMorada As SizeF = e.Graphics.MeasureString(strMorada, fntMoradaEmpresa)
                Dim szfCódigoPostal As SizeF = e.Graphics.MeasureString(strCódigoPostal, fntMoradaEmpresa)
                Dim szfLocalidade As SizeF = e.Graphics.MeasureString(strLocalidade, fntMoradaEmpresa)

                e.Graphics.DrawString(strNomeEmpresa, fntNomeEmpresa, Brushes.Black, sglMargemEsquerda, 75, New StringFormat())
                e.Graphics.DrawString(strMorada, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda, 75 + szfNomeEmpresa.Height, New StringFormat())
                e.Graphics.DrawString(strCódigoPostal, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda, 75 + szfNomeEmpresa.Height + szfMorada.Height, New StringFormat())
                e.Graphics.DrawString(strLocalidade, fntMoradaEmpresa, Brushes.Black, sglMargemEsquerda + szfCódigoPostal.Width, 75 + szfNomeEmpresa.Height + szfMorada.Height, New StringFormat())

                ' Desenha o Título Centrado
                Dim x As Single = (sglMargemDireita - sglMargemEsquerda) / 2
                Dim y As Single = 200.0
                e.Graphics.DrawString("Recibo de Remuneração", fntTítulo, Brushes.Black, x, y, New StringFormat)

                ' Desenha o texto do recibo
                Dim strNome As String = dgvMês.Rows(intRowActual).Cells(colNomeFuncionário.Index).Value
                Dim strFunção As String = dgvMês.Rows(intRowActual).Cells(colFunção.Index).Value
                Dim strNúmeroSegSocial As String = dgvMês.Rows(intRowActual).Cells(colNúmeroSegSocial.Index).Value
                Dim strNIF As String = dgvMês.Rows(intRowActual).Cells(colNIF.Index).Value
                Dim sglTotalLíquido As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTotalLíquido.Index).Value)
                Dim strData As String
                If strMês = "Férias" Then
                    strData = "Subsídio de Férias"
                ElseIf strMês = "Natal" Then
                    strData = "Subsídio de Natal"
                Else
                    strData = String.Format("{0:00}", Int(calMês.ActiveMonth.Month)) & "-" & calMês.ActiveMonth.Year.ToString
                End If

                Dim szfNome As SizeF = e.Graphics.MeasureString(strNome, fntDados)
                Dim szfFunção As SizeF = e.Graphics.MeasureString(strFunção, fntDados)
                Dim szfNúmeroSegSocial As SizeF = e.Graphics.MeasureString(strNúmeroSegSocial, fntDados)
                Dim szfNIF As SizeF = e.Graphics.MeasureString(strNIF, fntDados)
                Dim szfTotalLíquido As SizeF = e.Graphics.MeasureString(sglTotalLíquido.ToString("#,##0.00 €"), fntDados)
                Dim szfData As SizeF = e.Graphics.MeasureString(strData, fntDados)

                x = sglMargemEsquerda
                y += 50

                subDesenhaString(e.Graphics, x, y, strNome, fntDados, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, ", inscrito na Segurança Social, sob o número", fntTexto, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, String.Format("{0:0 000 000 000}", Convert.ToUInt64(strNúmeroSegSocial)), fntDados, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, ", com a categoria profissional", fntTexto, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, strFunção, fntDados, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, "e Número de Contribuinte", fntTexto, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, String.Format("{0:000 000 000}", Convert.ToUInt64(strNIF)), fntDados, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, "recebeu a quantia de", fntTexto, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, sglTotalLíquido.ToString("#,##0.00 €"), fntDados, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, "referente a", fntTexto, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, strData, fntDados, sglMargemEsquerda, sglMargemDireita)
                subDesenhaString(e.Graphics, x, y, ".", fntTexto, sglMargemEsquerda, sglMargemDireita)

                Dim intDiasMês As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasMês.Index).Value)
                Dim intDiasBaixa As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasBaixa.Index).Value)
                Dim intDiasFérias As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasFérias.Index).Value)
                Dim intDiasFaltas As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasFaltas.Index).Value)
                Dim sglRemuneraçãoDiária As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colRemuneraçãoDiária.Index).Value)
                Dim sglRemuneraçãoBase As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colRemuneraçãoBase.Index).Value)
                Dim intDiasSubRefeição As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasSubRefeição.Index).Value)
                Dim sglSubRefeiçãoDias As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colSubRefeiçãoDia.Index).Value)
                Dim sglSubRefeiçãoTotal As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colSubRefeiçãoMês.Index).Value)
                Dim sglHorasExtras As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colHorasExtras.Index).Value)
                Dim sglReduçãoVencimentoFaltas As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colReduçãoVencimentoFaltas.Index).Value)
                Dim sglTotalIlíquido As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTotalIlíquido.Index).Value)


                Dim sglPrimeiraColuna As Single = 180.0
                Dim sglSegundaColuna As Single = 430.0
                Dim sglTerceiraColuna As Single = 440.0
                Dim sglQuartaColuna As Single = 530.0
                Dim sglQuintaColuna As Single = 620.0
                Dim sglEspaçoLinha As Single = 19.0

                Dim sfDireita As New Drawing.StringFormat
                sfDireita.Alignment = StringAlignment.Far

                y += 80
                x = sglPrimeiraColuna
                e.Graphics.DrawString("Remuneração Base:", fntTexto, Brushes.Black, x, y, New StringFormat)
                x = sglSegundaColuna
                e.Graphics.DrawString(intDiasMês.ToString, fntDados, Brushes.Black, x, y, sfDireita)
                x = sglTerceiraColuna
                e.Graphics.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
                x = sglQuartaColuna
                e.Graphics.DrawString(sglRemuneraçãoDiária.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
                x = sglQuintaColuna
                e.Graphics.DrawString(sglRemuneraçãoBase.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)

                If IsNumeric(strMês) Then
                    y += sglEspaçoLinha
                    x = sglPrimeiraColuna
                    e.Graphics.DrawString("Subsídio de Refeição:", fntTexto, Brushes.Black, x, y, New StringFormat)
                    x = sglSegundaColuna
                    e.Graphics.DrawString(intDiasSubRefeição.ToString, fntDados, Brushes.Black, x, y, sfDireita)
                    x = sglTerceiraColuna
                    e.Graphics.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
                    x = sglQuartaColuna
                    e.Graphics.DrawString(sglSubRefeiçãoDias.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
                    x = sglQuintaColuna
                    e.Graphics.DrawString(sglSubRefeiçãoTotal.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
                End If
                If sglHorasExtras > 0 Then
                    y += sglEspaçoLinha
                    x = sglPrimeiraColuna
                    e.Graphics.DrawString("Total Horas Extras:", fntTexto, Brushes.Black, x, y, New StringFormat)
                    x = sglQuintaColuna
                    e.Graphics.DrawString(sglHorasExtras.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
                End If

                If intDiasBaixa > 0 Then
                    y += sglEspaçoLinha
                    x = sglPrimeiraColuna
                    e.Graphics.DrawString("Baixa:", fntTexto, Brushes.Black, x, y, New StringFormat)
                    x = sglSegundaColuna
                    e.Graphics.DrawString(intDiasBaixa.ToString, fntDados, Brushes.Black, x, y, sfDireita)
                    'x = sglTerceiraColuna
                    'e.Graphics.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
                    x = sglQuintaColuna
                    e.Graphics.DrawString("0,00 €", fntDados, Brushes.Black, x, y, sfDireita)
                End If

                If intDiasFaltas > 0 Then
                    y += sglEspaçoLinha
                    x = sglPrimeiraColuna
                    e.Graphics.DrawString("Faltas Injustificadas:", fntTexto, Brushes.Black, x, y, New StringFormat)
                    x = sglSegundaColuna
                    e.Graphics.DrawString(intDiasFaltas.ToString, fntDados, Brushes.Black, x, y, sfDireita)
                    'x = sglTerceiraColuna
                    'e.Graphics.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
                    ' TODO -> Acrescentar este valor
                    'x = sglQuartaColuna
                    'e.Graphics.DrawString(sglReduçãoVencimentoFaltas.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
                    x = sglQuintaColuna
                    e.Graphics.DrawString(sglReduçãoVencimentoFaltas.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
                End If

                y += sglEspaçoLinha + 2
                e.Graphics.DrawLine(Pens.Black, sglQuartaColuna, y, sglQuintaColuna, y)
                y += 2
                x = sglPrimeiraColuna
                e.Graphics.DrawString("Total Ilíquido:", fntDados, Brushes.Black, x, y, New StringFormat)
                x = sglQuintaColuna
                e.Graphics.DrawString(sglTotalIlíquido.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)

                Dim sglSujeitoDescontos As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colSujeitoDescontos.Index).Value)
                Dim sglTaxaSegSocial As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTaxaSegSocial.Index).Value)
                Dim sglDescontosSegSocial As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colDescontoSegSocial.Index).Value)
                Dim sglTaxaIRS As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTaxaIRS.Index).Value)
                Dim sglDescontosIRS As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colDescontoIRS.Index).Value)
                Dim sglTotalDescontos As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTotalDescontos.Index).Value)

                y += 80
                x = sglPrimeiraColuna
                e.Graphics.DrawString("Desconto Segurança Social:", fntTexto, Brushes.Black, x, y, New StringFormat)
                x = sglSegundaColuna
                e.Graphics.DrawString(sglTaxaSegSocial.ToString("#,#00.0 %"), fntDados, Brushes.Black, x, y, sfDireita)
                x = sglTerceiraColuna
                e.Graphics.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
                x = sglQuartaColuna
                e.Graphics.DrawString(sglSujeitoDescontos.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
                x = sglQuintaColuna
                e.Graphics.DrawString(sglDescontosSegSocial.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)

                y += sglEspaçoLinha
                x = sglPrimeiraColuna
                e.Graphics.DrawString("Desconto IRS:", fntTexto, Brushes.Black, x, y, New StringFormat)
                x = sglSegundaColuna
                e.Graphics.DrawString(sglTaxaIRS.ToString("#,#00.0 %"), fntDados, Brushes.Black, x, y, sfDireita)
                x = sglTerceiraColuna
                e.Graphics.DrawString("x", fntTexto, Brushes.Black, x, y, New StringFormat)
                x = sglQuartaColuna
                e.Graphics.DrawString(sglSujeitoDescontos.ToString("#,##0.00 €"), fntTexto, Brushes.Black, x, y, sfDireita)
                x = sglQuintaColuna
                e.Graphics.DrawString(sglDescontosIRS.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)

                y += sglEspaçoLinha + 2
                e.Graphics.DrawLine(Pens.Black, sglQuartaColuna, y, sglQuintaColuna, y)
                y += 2
                x = sglPrimeiraColuna
                e.Graphics.DrawString("Total Descontos:", fntDados, Brushes.Black, x, y, New StringFormat)
                x = sglQuintaColuna
                e.Graphics.DrawString(sglTotalDescontos.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)

                y += 80
                x = sglPrimeiraColuna
                e.Graphics.DrawString("Total Líquido:", fntDados, Brushes.Black, x, y, New StringFormat)
                x = sglQuintaColuna
                e.Graphics.DrawString(sglTotalLíquido.ToString("#,##0.00 €"), fntDados, Brushes.Black, x, y, sfDireita)
                e.Graphics.DrawRectangle(penPreta2, 160, y - 10, 490, sglEspaçoLinha * 2)

                If strTipoImpressão = "Contabilidade" Then
                    y += 80
                    x = 160
                    e.Graphics.DrawString("Assinatura: __ __ __ __ __ __ __ __ __ __ __ __ __ __", fntTexto, Brushes.Black, x, y, New StringFormat)

                    Dim strNIB As String = dgvMês.Rows(intRowActual).Cells(colNIB.Index).Value
                    y += 50
                    x = 160
                    e.Graphics.DrawString("NIB:", fntOutros, Brushes.Black, x, y, New StringFormat)
                    x = 200
                    e.Graphics.DrawString(String.Format("{0:0000 0000 00000000000 00}", Convert.ToUInt64(strNIB)), fntOutros, Brushes.Black, x, y, New StringFormat)
                End If

                y += 50
                e.Graphics.DrawLine(penCinza3, sglMargemEsquerda, y, sglMargemDireita, y)

                y = 150
                x = sglMargemDireita
                e.Graphics.DrawString(strTipoImpressão, fntOutros, Brushes.Black, x, y, sfDireita)
                'Else
                '    intRowActual += 1
            End If
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            e.HasMorePages = False

            If (intRowActual + 1 < dgvMês.Rows.Count - 1) Then
                intRowActual += 1
                For i As Integer = intRowActual To dgvMês.Rows.Count - 1
                    If dgvMês.Rows(i).Cells(colImprimir.Index).Value Then
                        e.HasMorePages = True
                        intRowActual = i
                        Exit For
                    End If
                Next
            End If

            If strTipoImpressão = "Contabilidade" AndAlso Not e.HasMorePages Then
                If chkFuncionário.Checked Then
                    strTipoImpressão = "Funcionário"
                    intRowActual = 0
                    e.HasMorePages = True
                ElseIf chkArquivo.Checked Then
                    strTipoImpressão = "Arquivo"
                    For i As Integer = 0 To dgvMês.Rows.Count - 1
                        If dgvMês.Rows(i).Cells(colImprimir.Index).Value Then
                            e.HasMorePages = True
                            intRowActual = i
                            Exit For
                        End If
                    Next
                    e.HasMorePages = True
                Else
                    e.HasMorePages = False
                End If
            End If

            If Not e.HasMorePages Then
                If strTipoImpressão = "Funcionário" AndAlso chkArquivo.Checked Then
                    strTipoImpressão = "Arquivo"
                    For i As Integer = 0 To dgvMês.Rows.Count - 1
                        If dgvMês.Rows(i).Cells(colImprimir.Index).Value Then
                            e.HasMorePages = True
                            intRowActual = i
                            Exit For
                        End If
                    Next
                    e.HasMorePages = True
                Else
                    e.HasMorePages = False
                End If
            End If
        End Try
    End Sub
    ''' <summary>
    ''' Fim de impressão, neste caso é só fim não temos que fazer nada
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="byvale"></param>
    ''' <remarks></remarks>
    Private Sub End_Print(ByVal sender As Object, ByVal byvale As Printing.PrintEventArgs)

    End Sub
    ''' <summary>
    ''' Divide o texto em palavras
    ''' Testa se o comprimento da palavra cabe na folha (na horizontal) se sim desenha a seguir, se não desenha na linha a baixo
    ''' </summary>
    ''' <param name="g">O ambiente gráfico onde vamos desenhar</param>
    ''' <param name="X">Cota X</param>
    ''' <param name="Y">Cota Y</param>
    ''' <param name="Texto">A string que vamos desenhar</param>
    ''' <param name="Fonte">O tipo de letra</param>
    ''' <param name="MargemEsquerda"></param>
    ''' <param name="MargemDireita"></param>
    ''' <remarks></remarks>
    Private Sub subDesenhaString(ByVal g As Graphics, ByRef X As Single, ByRef Y As Single, ByVal Texto As String, ByVal Fonte As Font, ByVal MargemEsquerda As Single, ByVal MargemDireita As Single)
        Try
            Dim Palavras() As String = Texto.Split(" ")
            For Each s As String In Palavras
                Dim tamanho As SizeF = g.MeasureString(s, Fonte)
                If X + tamanho.Width > MargemDireita Then
                    X = MargemEsquerda
                    Y += tamanho.Height
                End If
                g.DrawString(s, Fonte, Brushes.Black, X, Y, New StringFormat)
                X += tamanho.Width
            Next
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub

    ''' <summary>
    ''' Carrega os valores dos funcionários relativos ao mês ou subsídio seleccionado no calendário.
    ''' E formata a tabela
    ''' </summary>
    ''' <param name="Mês">Carrega mês ou subsídio dependendo do tipo de valor deste parametro</param>
    ''' <remarks></remarks>
    Private Sub subCarregaValoresMês(ByVal Mês As String)
        Try
            dgvMês.Rows.Clear()
            ' Selecciona todos os funcionários que no Mês e Ano seleccionado eram funcionário (já tinham sido admitidos e não tinham rescindido)
            Dim strSelectSQL As String = "SELECT * FROM Funcionários, Mês WHERE "
            strSelectSQL += "Funcionários.NúmeroFuncionário = Mês.NúmeroFuncionário AND "
            strSelectSQL += "Mês.Ano='" & calMês.ActiveMonth.Year.ToString() & "' AND "
            If Mês = "Férias" Then
                strSelectSQL += "Mês.Mês='14' " ' 14º Mês
            ElseIf Mês = "Natal" Then
                strSelectSQL += "Mês.Mês='13' " ' 13º Mês
            Else
                strSelectSQL += "Mês.Mês='" & calMês.ActiveMonth.Month.ToString("00") & "' "
            End If
            strSelectSQL += "ORDER BY Funcionários.Nome ASC "

            Dim sqlConnSelect As New SqlConnection(Settings.strSQLConnection)
            Dim commandSelect As New SqlCommand(strSelectSQL, sqlConnSelect)
            sqlConnSelect.Open()

            ' Executa o comando colocando num SqlDataReader os resultados
            Dim readerFuncionário As SqlDataReader = commandSelect.ExecuteReader()
            ' Caso existam rows (linhas)
            If readerFuncionário.HasRows Then
                While readerFuncionário.Read()
                    Dim strNúmeroFuncionário As String = readerFuncionário.Item("NúmeroFuncionário").ToString.Trim
                    Dim intAno As Integer = Int(readerFuncionário.Item("Ano"))
                    Dim intMês As Integer
                    If Mês = "Férias" Then
                        intMês = 14 ' 14º Mês
                    ElseIf Mês = "Natal" Then
                        intMês = 13 ' 13º Mês
                    Else
                        intMês = Int(readerFuncionário.Item("Mês"))
                    End If
                    Dim strNome As String = readerFuncionário.Item("Nome").ToString.Trim
                    Dim strFunção As String = readerFuncionário.Item("Função").ToString.Trim
                    Dim strNúmeroSegSocial As String = readerFuncionário.Item("NúmeroSegSocial").ToString.Trim
                    Dim strNIF As String = readerFuncionário.Item("NIF").ToString.Trim
                    Dim strNIB As String = readerFuncionário.Item("NIB").ToString.Trim
                    Dim intDiasMês As Integer = Int(readerFuncionário.Item("DiasMês"))
                    Dim intDiasBaixa As Integer = Int(readerFuncionário.Item("DiasBaixa"))
                    Dim intDiasFérias As Integer = Int(readerFuncionário.Item("DiasFérias"))
                    Dim intDiasFaltas As Integer = Int(readerFuncionário.Item("DiasFaltas"))
                    Dim sglRemuneraçãoDiária As Single = Round(Convert.ToDecimal(readerFuncionário.Item("VencimentoBase").ToString.Trim) / intDiasMês)
                    Dim sglRemuneraçãoBase As Single = Convert.ToDecimal(readerFuncionário.Item("VencimentoBase").ToString.Trim)
                    Dim intDiasSubRefeição As Integer = Int(readerFuncionário.Item("DiasSubRefeição"))
                    Dim sglSubRefeiçãoDias As Single = Convert.ToSingle(readerFuncionário.Item("SubRefeição"))
                    Dim sglSubRefeiçãoTotal As Single = intDiasSubRefeição * sglSubRefeiçãoDias
                    Dim sglHorasExtras As Single = 0.0

                    ' ---------------------------------------
                    ' Cálculo das horas extras do funcionário
                    Dim strHorasExtrasSQL As String = "SELECT * FROM  HorasExtras WHERE "
                    strHorasExtrasSQL += "NúmeroFuncionário ='" & strNúmeroFuncionário.ToString & "' AND "
                    strHorasExtrasSQL += "Ano='" & calMês.ActiveMonth.Year.ToString() & "' AND "
                    strHorasExtrasSQL += "Mês='" & calMês.ActiveMonth.Month.ToString("00") & "' "

                    Dim sqlConnHorasExtras As New SqlConnection(Settings.strSQLConnection)
                    Dim commandHorasExtras As New SqlCommand(strHorasExtrasSQL, sqlConnHorasExtras)
                    sqlConnHorasExtras.Open()

                    Dim readerHorasExtras As SqlDataReader = commandHorasExtras.ExecuteReader()
                    ' Caso existam rows (linhas)
                    If readerHorasExtras.HasRows Then
                        While readerHorasExtras.Read()
                            Dim sglNúmeroHorasExtras As Single = Convert.ToSingle(readerHorasExtras.Item("NúmeroHoras"))
                            Dim sglValorHoraNormal As Single = Convert.ToSingle(readerHorasExtras.Item("ValorHoraNormal"))
                            Dim sglPercentagem As Single = Convert.ToSingle(readerHorasExtras.Item("Percentagem"))
                            sglHorasExtras += sglNúmeroHorasExtras * sglValorHoraNormal * (sglPercentagem + 1.0)
                        End While
                    End If
                    sqlConnHorasExtras.Close()
                    sqlConnHorasExtras = Nothing
                    commandHorasExtras = Nothing
                    ' ---------------------------------------
                    ' Continuamos com a consulta anterior

                    Dim sglReduçãoVencimentoFaltas As Single = intDiasFaltas * Settings.intNúmeroHorasDiárias * modCálculos.funVencimentoHora(Convert.ToDecimal(readerFuncionário.Item("VencimentoBase").ToString.Trim), Settings.intNúmeroHorasSemanais)
                    Dim sglTotalIlíquido As Single = sglRemuneraçãoBase + sglHorasExtras + sglSubRefeiçãoTotal - sglReduçãoVencimentoFaltas
                    If sglTotalIlíquido < 0 Then sglTotalIlíquido = 0 ' De lei, o funcionário quando falta pode descontar mais doque ganharia, e teria que pagar à entidade patronal, mas a lei não permite o funcionário pagar à entidade patronal pelo que o total a receber=0
                    Dim sglSujeitoDescontos As Single = sglRemuneraçãoBase + sglHorasExtras - sglReduçãoVencimentoFaltas
                    If sglSujeitoDescontos < 0 Then sglSujeitoDescontos = 0
                    Dim sglTaxaSegSocial As Single
                    If readerFuncionário.Item("SócioEmpresa").ToString.Trim = "" Then
                        sglTaxaSegSocial = Settings.sglTaxaSegSocialFuncionário / 100
                    Else
                        sglTaxaSegSocial = Settings.sglTaxaSegSocialSócio / 100
                    End If
                    Dim sglDescontosSegSocial As Single = sglTaxaSegSocial * sglSujeitoDescontos
                    Dim sglTaxaIRS As Single = Convert.ToSingle(readerFuncionário.Item("TaxaIRS"))
                    Dim sglDescontosIRS As Single = Int(sglTaxaIRS * sglSujeitoDescontos)
                    Dim sglTotalDescontos As Single = sglDescontosSegSocial + sglDescontosIRS
                    Dim sglTotalLíquido As Single = sglTotalIlíquido - sglTotalDescontos

                    dgvMês.Rows.Add(strNúmeroFuncionário, intAno, intMês, strNome, strFunção, strNúmeroSegSocial, strNIF, strNIB, intDiasMês, intDiasBaixa, intDiasFaltas, intDiasFérias, sglRemuneraçãoDiária, sglRemuneraçãoBase, intDiasSubRefeição, sglSubRefeiçãoDias, sglSubRefeiçãoTotal, sglHorasExtras, sglReduçãoVencimentoFaltas, sglTotalIlíquido, sglSujeitoDescontos, sglTaxaSegSocial, sglDescontosSegSocial, sglTaxaIRS, sglDescontosIRS, sglTotalDescontos, sglTotalLíquido, True)
                End While
            End If
            ' Fecha a ligação e limpa as variáveis
            sqlConnSelect.Close()
            sqlConnSelect = Nothing
            commandSelect = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        Finally
            subCalculaTotais()
        End Try
    End Sub
    ''' <summary>
    ''' Calsola os totais do Mês para:
    ''' Descontos Segurança Social
    ''' Descontos IRS
    ''' Valores Líquidos
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subCalculaTotais()
        Try
            Dim sglTotalDescontoSegSocial As Single = 0.0
            Dim sglTotalDescontoIRS As Single = 0.0
            Dim sglTotalLíquido As Single = 0.0

            For Each row As DataGridViewRow In dgvMês.Rows
                If Not row.IsNewRow Then
                    If Convert.ToDecimal(dgvMês.Rows(row.Index).Cells(colTaxaSegSocial.Index).Value) = Settings.sglTaxaSegSocialFuncionário Then
                        sglTotalDescontoSegSocial += Round(Convert.ToDecimal(dgvMês.Rows(row.Index).Cells(colSujeitoDescontos.Index).Value) * Settings.sglTaxaSegSocialFuncionárioEmpresa / 100, 2)
                    Else
                        sglTotalDescontoSegSocial += Round(Convert.ToDecimal(dgvMês.Rows(row.Index).Cells(colSujeitoDescontos.Index).Value) * Settings.sglTaxaSegSocialSócioEmpresa / 100, 2)
                    End If
                    sglTotalDescontoIRS += Int(dgvMês.Rows(row.Index).Cells(colDescontoIRS.Index).Value)
                    sglTotalLíquido += Round(Convert.ToDecimal(dgvMês.Rows(row.Index).Cells(colTotalLíquido.Index).Value), 2)
                End If
            Next

            txbTotalDescontoSegSocial.Text = sglTotalDescontoSegSocial.ToString("#,##0.00 €")
            txbTotalDescontoIRS.Text = sglTotalDescontoIRS.ToString("#,##0.00 €")
            txbTotalLíquido.Text = sglTotalLíquido.ToString("#,##0.00 €")
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
    ''' <summary>
    ''' Vamos gravar os totais na base de dados
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub subGravarTotais()
        Try
            Dim x As Integer

            Dim intDiasMês As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasMês.Index).Value)
            Dim intDiasSubRefeição As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasSubRefeição.Index).Value)
            Dim intDiasFérias As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasFérias.Index).Value)
            Dim intDiasBaixa As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasBaixa.Index).Value)
            Dim intDiasFaltas As Integer = Int(dgvMês.Rows(intRowActual).Cells(colDiasFaltas.Index).Value)
            Dim sglRemuneraçãoDiária As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colRemuneraçãoDiária.Index).Value)
            Dim sglRemuneraçãoBase As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colRemuneraçãoBase.Index).Value)
            Dim sglSubRefeiçãoDias As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colSubRefeiçãoDia.Index).Value)
            Dim sglSubRefeiçãoTotal As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colSubRefeiçãoMês.Index).Value)
            Dim sglTotalHorasExtras As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colHorasExtras.Index).Value)
            Dim sglReduçãoVencimentoFaltas As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colReduçãoVencimentoFaltas.Index).Value)
            Dim sglTotalIlíquido As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTotalIlíquido.Index).Value)
            Dim sglSujeitoDescontos As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colSujeitoDescontos.Index).Value)
            Dim sglTaxaSegSocial As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTaxaSegSocial.Index).Value)
            Dim sglDescontosSegSocial As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colDescontoSegSocial.Index).Value)
            Dim sglTaxaIRS As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTaxaIRS.Index).Value)
            Dim sglDescontosIRS As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colDescontoIRS.Index).Value)
            Dim sglTotalDescontos As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTotalDescontos.Index).Value)
            Dim sglTotalLíquido As Single = Convert.ToSingle(dgvMês.Rows(intRowActual).Cells(colTotalLíquido.Index).Value)

            'IF EXISTS (SELECT * FROM Table1 WHERE Column1='SomeValue')
            'UPDATE Table1 SET (...) WHERE Column1='SomeValue'
            'Else
            'INSERT INTO Table1 VALUES (...)
            Dim strComandoSQL As String = "IF EXISTS (SELECT * FROM TotalMês WHERE "
            strComandoSQL += "NúmeroFuncionário='" & dgvMês.Rows(intRowActual).Cells(colNúmeroFuncionário.Index).Value.ToString & "' AND "
            strComandoSQL += "Ano='" & Int(dgvMês.Rows(intRowActual).Cells(colAno.Index).Value) & "' AND "
            strComandoSQL += "Mês='" & Int(dgvMês.Rows(intRowActual).Cells(colMês.Index).Value) & "' "
            strComandoSQL += ") "
            strComandoSQL += "UPDATE TotalMês SET "
            strComandoSQL += "SujeitoDescontos=Convert(real," & sglSujeitoDescontos.ToString.Replace(",", ".") & "), "
            strComandoSQL += "TaxaIRS=Convert(real," & sglTaxaIRS.ToString.Replace(",", ".") & "), "
            strComandoSQL += "DescontoIRS=Convert(real," & sglDescontosIRS.ToString.Replace(",", ".") & ") "
            strComandoSQL += "WHERE ("
            strComandoSQL += "NúmeroFuncionário='" & dgvMês.Rows(intRowActual).Cells(colNúmeroFuncionário.Index).Value.ToString & "' AND "
            strComandoSQL += "Ano='" & Int(dgvMês.Rows(intRowActual).Cells(colAno.Index).Value) & "' AND "
            strComandoSQL += "Mês='" & Int(dgvMês.Rows(intRowActual).Cells(colMês.Index).Value) & "' "
            strComandoSQL += ") "
            strComandoSQL += "ELSE "
            strComandoSQL += "INSERT TotalMês  VALUES ("
            strComandoSQL += "'" & dgvMês.Rows(intRowActual).Cells(colNúmeroFuncionário.Index).Value.ToString & "', "
            strComandoSQL += "'" & Int(dgvMês.Rows(intRowActual).Cells(colAno.Index).Value) & "', "
            strComandoSQL += "'" & Int(dgvMês.Rows(intRowActual).Cells(colMês.Index).Value) & "', "
            strComandoSQL += "Convert(real," & sglSujeitoDescontos.ToString.Replace(",", ".") & "), "
            strComandoSQL += "Convert(real," & sglTaxaIRS.ToString.Replace(",", ".") & "), "
            strComandoSQL += "Convert(real," & sglDescontosIRS.ToString.Replace(",", ".") & ") "
            strComandoSQL += ") "

            Dim sqlConn As New SqlConnection(Settings.strSQLConnection)
            Dim execCommand As New SqlCommand(strComandoSQL, sqlConn)
            sqlConn.Open()
            x = execCommand.ExecuteNonQuery
            sqlConn.Close()
            sqlConn = Nothing
            execCommand = Nothing
            strComandoSQL = Nothing
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub

    ''' <summary>
    ''' Formata o calendário mediante se é Sábado, Domingo ou Feriado
    ''' E calcula o nº total de dias do mês e nº total de dias úteis do mês
    ''' </summary>
    ''' <param name="Ano"></param>
    ''' <param name="Mês"></param>
    ''' <remarks></remarks>
    Private Sub subFormataCalendário(ByVal Ano As Integer, ByVal Mês As Integer)
        Try
            intDiasTotaisMês = 30 ' Para efeitos de segurança social, o mês tem sempre 30 diasSystem.DateTime.DaysInMonth(Ano, Mês)
            calMês.ResetDateInfo() ' Limpa as datas formatadas
            Dim dtData As DateTime = New DateTime(Ano, Mês, 1)
            Dim diaDatas As Pabo.Calendar.DateItem() = New Pabo.Calendar.DateItem(System.DateTime.DaysInMonth(Ano, Mês)) {}
            diaDatas.Initialize()
            For i As Integer = 1 To System.DateTime.DaysInMonth(Ano, Mês)
                diaDatas(i) = New Pabo.Calendar.DateItem()
                If funDiaFeriado(dtData) = "" Then
                    ' Não é Feriado
                    If dtData.DayOfWeek = DayOfWeek.Saturday Then
                        ' É sábado
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.LightBlue
                    ElseIf dtData.DayOfWeek = DayOfWeek.Sunday Then
                        ' É Domingo
                        diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                        diaDatas(i).BackColor1 = Color.OrangeRed
                    Else
                        ' Não é feriado e é dia útil
                        intDiasÚteis += 1
                    End If
                Else
                    ' É feriado
                    diaDatas(i).[Date] = New DateTime(Ano, Mês, i)
                    diaDatas(i).BackColor1 = Color.Orange
                End If
                dtData = dtData.AddDays(1) ' Passa para o próximo dia
            Next
            calMês.AddDateInfo(diaDatas)
        Catch ex As Exception
            modLog.subErro(ex)
        End Try
    End Sub
End Class