﻿Imports System.Xml
''' <summary>
''' Módulo onde vão ser armazenadas as setting, não estou a usar as settings o vb.net porque não me permite alterar as settings da aplicação apenas do user
''' </summary>
''' <remarks></remarks>
Module modMySettings
    ' TODO -> Exporta e importar de para ficheixo XML
    ' TODO -> Criar instalador e base de dados SQL
    ' TODO -> Form para edição de settings
    ' ##### SQL #####
    '"Provider=SQLNCLI10;Server=myServerAddress;Database=myDataBase;Uid=myUsername; Pwd=myPassword;"
    'Dim strConnection As String = "Data Source=.\SQLEXPRESS;AttachDbFilename='C:\CSC-EA\CSC-EA.mdf';" & ";Integrated Security=True;User Instance=True"
    ' Data Source=myServerAddress;Initial Catalog=myDataBase;User Id=myUsername;Password=myPassword;
    ' Server=myServerAddress;Database=myDataBase;User ID=myUsername;Password=myPassword;Trusted_Connection=False;

    Public strDataSouce As String
    'Public strAttachDbFilename As String = "C:\CSC-EA\Funcionários.mdf"
    Public strAttachDbFilename As String
    'Public strSQLConnection As String = "Data Source=" & strDataSouce & ";AttachDbFilename='" & strAttachDbFilename & "';" & "Integrated Security=SSPI;"
    Public strSQLConnection As String = "Data Source=" & strDataSouce & ";AttachDbFilename='" & strAttachDbFilename & "\Funcionários.mdf';" & "Integrated Security=SSPI;"

    ' ##### Dados da Empresa #####
    Public strNomeEmpresa As String
    Public strMoradaEmpresa As String
    Public strCódigoPostalEmpresa As String
    Public strLocalidadeEmpresa As String

    ' ##### Configuração #####
    ' TODO -> compatibilizar os valores lidos e gravados
    Public intNúmeroHorasExtrasMáximasDia As Integer ' Número máximo de horas extras por dia permitidas por lei
    Public intNúmeroHorasSemanais As Integer ' Número de horas de trabalho durante uma semana normal
    Public intNúmeroHorasDiárias As Integer ' Número de horas de trabalho durante um dia normal
    Public sglTaxaSegSocialSócioEmpresa As Single ' Valor da segurança social a pagar pela empresa
    Public sglTaxaSegSocialFuncionárioEmpresa As Single  ' Valor da segurança social a pagar pela empresa
    Public sglTaxaSegSocialSócio As Single  ' Valor da segurança social a pagar pelo funcionário
    Public sglTaxaSegSocialFuncionário As Single  ' Valor da segurança social a pagar pelo funcionário

    ''' <summary>
    ''' Esta rotina grava num ficheiro XML as configurações do programa
    ''' Também podia gravar uma parte da base de dados SQL, mas assim é mais fácil de alterar
    ''' e há configurações, por exemplo: do servidor SQL que não podem ser guardadas na base de dados, 
    ''' não é possível aceder a um servidor se não sabemos a qual nem a que base de dados
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub subGravarConfig()
        Try
            ' Cria um novo ficheiro XML com a codificação UTF8
            Dim xmlw As New XmlTextWriter("Config.xml", System.Text.Encoding.UTF8)
            xmlw.Formatting = Formatting.Indented

            xmlw.WriteStartDocument()

            ' Adiciona um comentário geral
            xmlw.WriteComment("Configuração Geral")

            ' Criar um elemento geral
            xmlw.WriteStartElement("Config")

            ' Criar o elemento "Dados SQL" e alguns dados
            With xmlw
                .WriteStartElement("Dados SQL")
                .WriteElementString("SQLServer", strDataSouce)
                .WriteElementString("SQLDbPath", strAttachDbFilename)
                .WriteEndElement()
            End With

            ' Criar o elemento "Dados Empresa" e alguns dados
            With xmlw
                .WriteStartElement("Dados Empresa")
                .WriteElementString("Nome", strNomeEmpresa)
                .WriteElementString("Morada", strMoradaEmpresa)
                .WriteElementString("CódigoPostal", strCódigoPostalEmpresa)
                .WriteElementString("Localidade", strLocalidadeEmpresa)
                .WriteEndElement()
            End With

            ' Criar o elemento "Configurações impostas pela Lei Portuguesa" e alguns dados
            With xmlw
                .WriteStartElement("Configurações Lei")
                .WriteElementString("NúmeroHorasExtrasMáximasDia", intNúmeroHorasExtrasMáximasDia.ToString)
                .WriteElementString("NúmeroHorasSemanais", intNúmeroHorasSemanais.ToString)
                .WriteElementString("NúmeroHorasDiárias", intNúmeroHorasDiárias.ToString)
                .WriteElementString("TaxaSegSocialSócioEmpresa", sglTaxaSegSocialSócioEmpresa.ToString)
                .WriteElementString("TaxaSegSocialFuncionárioEmpresa", sglTaxaSegSocialFuncionárioEmpresa.ToString)
                .WriteElementString("TaxaSegSocialSócio", sglTaxaSegSocialSócio.ToString)
                .WriteElementString("TaxaSegSocialFuncionário", sglTaxaSegSocialFuncionário.ToString)
                .WriteEndElement()
            End With

            xmlw.WriteEndElement() ' <- config
            xmlw.WriteEndDocument()

            ' Fecha o documento XML
            xmlw.Flush()
            xmlw.Close()
        Catch ex As Exception
            MsgBox("modMySettings: subGravarConfig -> " + ex.Message, MsgBoxStyle.Critical, "Erro a Gravar Configuração")
            'modLog.subLog("modMySettings: subGravarConfig -> " + ex.Message)
        End Try
    End Sub
    ''' <summary>
    ''' Enta rotina tenta ler a configuração, 
    ''' se não conseguir mete valores de defeito nas variáveis
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub subLerConfig()
        Try
            Dim xmlFile = XDocument.Load("Config.xml")

            ' Dados SQL
            strDataSouce = xmlFile...<SQLServer>.Value
            strAttachDbFilename = xmlFile...<SQLDbPath>.Value

            ' Dados Empresa
            strNomeEmpresa = xmlFile...<Nome>.Value
            strMoradaEmpresa = xmlFile...<Morada>.Value
            strCódigoPostalEmpresa = xmlFile...<CódigoPostal>.Value
            strLocalidadeEmpresa = xmlFile...<Localidade>.Value

            ' Configurações impostas pela Lei Portuguesa
            intNúmeroHorasExtrasMáximasDia = Int(xmlFile...<NúmeroHorasExtrasMáximasDia>.Value)
            intNúmeroHorasSemanais = Int(xmlFile...<NúmeroHorasSemanais>.Value)
            intNúmeroHorasDiárias = Int(xmlFile...<NúmeroHorasDiárias>.Value)
            sglTaxaSegSocialSócioEmpresa = Convert.ToSingle(xmlFile...<TaxaSegSocialSócioEmpresa>.Value)
            sglTaxaSegSocialFuncionárioEmpresa = Convert.ToSingle(xmlFile...<TaxaSegSocialFuncionárioEmpresa>.Value)
            sglTaxaSegSocialSócio = Convert.ToSingle(xmlFile...<TaxaSegSocialSócio>.Value)
            sglTaxaSegSocialFuncionário = Convert.ToSingle(xmlFile...<TaxaSegSocialFuncionário>.Value)
        Catch ex As Exception
            Dim resposta As Integer = MsgBox("Não foi possível ler o ficheiro de configuração", MsgBoxStyle.YesNo, "Quer carregar os valores de defeito")
            If resposta = vbYes Then
                strDataSouce = ".\SQLEXPRESS"
                strAttachDbFilename = "C:\CSC-EA"

                strNomeEmpresa = "CSC - Energia e Automação, Lda"
                strMoradaEmpresa = "Travessa da Vitória, 125"
                strCódigoPostalEmpresa = "4475-174"
                strLocalidadeEmpresa = "Gemunde"

                ' TODO -> compatibilizar os valores lidos e gravados
                intNúmeroHorasExtrasMáximasDia = 18
                intNúmeroHorasSemanais = 40
                intNúmeroHorasDiárias = 8
                sglTaxaSegSocialSócioEmpresa = 31.25 / 100.0
                sglTaxaSegSocialFuncionárioEmpresa = 34.75 / 100.0
                sglTaxaSegSocialSócio = 10.0 / 100.0
                sglTaxaSegSocialFuncionário = 11.0 / 100.0
            End If
        Finally
            strSQLConnection = "Data Source=" & strDataSouce & ";AttachDbFilename='" & strAttachDbFilename & "\Funcionários.mdf';" & "Integrated Security=SSPI;"
        End Try
    End Sub
End Module

